/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.NewWizardCollectionSorter;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.internal.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class NewWizardNewPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private WizardCollectionElement wizardCategories;
    private IWorkbench workbench;
    private NewWizardSelectionPage page;
    private IDialogSettings settings;
    private Hashtable selectedWizards = new Hashtable();
    private TreeViewer categoryTreeViewer;
    private TableViewer wizardSelectionViewer;
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;
    private static final String STORE_SELECTED_CATEGORY_ID = "NewWizardSelectionPage.STORE_SELECTED_CATEGORY_ID";
    private static final String STORE_EXPANDED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_WIZARD_ID = "NewWizardSelectionPage.STORE_SELECTED_WIZARD_ID";

    public NewWizardNewPage(NewWizardSelectionPage mainPage, IWorkbench aWorkbench, WizardCollectionElement wizardCategories) {
        this.page = mainPage;
        this.workbench = aWorkbench;
        this.wizardCategories = wizardCategories;
    }

    public void activate() {
        this.page.setDescription(WorkbenchMessages.getString("NewWizardNewPage.description"));
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)((IStructuredSelection)this.wizardSelectionViewer.getSelection())));
    }

    protected Control createControl(Composite parent) {
        Font wizardFont = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setFont(wizardFont);
        outerContainer.setLayoutData((Object)new GridData(272));
        Tree tree = new Tree(outerContainer, 2820);
        this.categoryTreeViewer = new TreeViewer(tree);
        GridData data = new GridData(1808);
        data.widthHint = 150;
        data.heightHint = 200;
        this.categoryTreeViewer.getTree().setLayoutData((Object)data);
        this.categoryTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.categoryTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.categoryTreeViewer.setSorter((ViewerSorter)NewWizardCollectionSorter.INSTANCE);
        this.categoryTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.wizardCategories.getParent(this.wizardCategories) == null) {
            this.categoryTreeViewer.setInput((Object)this.wizardCategories);
        } else {
            this.categoryTreeViewer.setInput((Object)new RootElementProxy(this.wizardCategories));
        }
        tree.setFont(wizardFont);
        Table table = new Table(outerContainer, 2820);
        this.wizardSelectionViewer = new TableViewer(table);
        data = new GridData(1808);
        data.widthHint = 150;
        data.heightHint = 200;
        this.wizardSelectionViewer.getTable().setLayoutData((Object)data);
        this.wizardSelectionViewer.setContentProvider(this.getWizardProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        table.setFont(wizardFont);
        this.restoreWidgetValues();
        if (!this.categoryTreeViewer.getSelection().isEmpty()) {
            this.categoryTreeViewer.getTree().setFocus();
        }
        return outerContainer;
    }

    protected Composite createViewPane(Composite parent, int width, int height) {
        Composite paneWindow = new Composite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = width;
        spec.heightHint = height;
        paneWindow.setLayoutData((Object)spec);
        paneWindow.setLayout((Layout)new FillLayout());
        return paneWindow;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, this.wizardSelectionViewer.getSelection()));
        this.page.advanceToNextPage();
    }

    protected void expandPreviouslyExpandedCategories() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        ArrayList<WizardCollectionElement> categoriesToExpand = new ArrayList<WizardCollectionElement>(expandedCategoryPaths.length);
        int i = 0;
        while (i < expandedCategoryPaths.length) {
            WizardCollectionElement category = this.wizardCategories.findChildCollection((IPath)new Path(expandedCategoryPaths[i]));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.categoryTreeViewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    protected IContentProvider getWizardProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof WizardCollectionElement) {
                    return ((WizardCollectionElement)o).getWizards();
                }
                return new Object[0];
            }
        };
    }

    private void handleCategorySelection(SelectionChangedEvent selectionEvent) {
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        Object currentSelection = this.wizardSelectionViewer.getInput();
        Object selectedCategory = this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (currentSelection != selectedCategory) {
            this.page.selectWizardNode(null);
            this.wizardSelectionViewer.setInput(selectedCategory);
        }
    }

    private void handleWizardSelection(SelectionChangedEvent selectionEvent) {
        WorkbenchWizardNode selectedNode;
        this.page.setErrorMessage(null);
        WorkbenchWizardElement currentSelection = (WorkbenchWizardElement)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (currentSelection == null) {
            this.page.setMessage(null);
            this.page.selectWizardNode(null);
            return;
        }
        if (this.selectedWizards.containsKey(currentSelection)) {
            selectedNode = (WorkbenchWizardNode)this.selectedWizards.get(currentSelection);
        } else {
            selectedNode = new WorkbenchWizardNode(this.page, currentSelection){

                public IWorkbenchWizard createWizard() throws CoreException {
                    return (INewWizard)this.wizardElement.createExecutableExtension();
                }
            };
            this.selectedWizards.put(currentSelection, selectedNode);
        }
        this.page.selectWizardNode(selectedNode);
        this.page.setMessage(currentSelection.getDescription());
    }

    protected void restoreWidgetValues() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryPaths == null) {
            return;
        }
        this.expandPreviouslyExpandedCategories();
        this.selectPreviouslySelectedCategoryAndWizard();
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCategoryAndWizard();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        if (selectionEvent.getSelectionProvider().equals(this.categoryTreeViewer)) {
            this.handleCategorySelection(selectionEvent);
        } else {
            this.handleWizardSelection(selectionEvent);
        }
    }

    protected void selectPreviouslySelectedCategoryAndWizard() {
        String categoryId = this.settings.get(STORE_SELECTED_CATEGORY_ID);
        if (categoryId == null) {
            return;
        }
        WizardCollectionElement category = this.wizardCategories.findChildCollection((IPath)new Path(categoryId));
        if (category == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)category);
        this.categoryTreeViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.categoryTreeViewer, (ISelection)selection));
        String wizardId = this.settings.get(STORE_SELECTED_WIZARD_ID);
        if (wizardId == null) {
            return;
        }
        WorkbenchWizardElement wizard = category.findWizard(wizardId, false);
        if (wizard == null) {
            return;
        }
        selection = new StructuredSelection((Object)wizard);
        this.wizardSelectionViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)selection));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        Object[] expandedElements = this.categoryTreeViewer.getExpandedElements();
        String[] expandedElementPaths = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedElementPaths[i] = ((WizardCollectionElement)expandedElements[i]).getPath().toString();
            ++i;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedElementPaths);
    }

    protected void storeSelectedCategoryAndWizard() {
        WorkbenchWizardElement selectedWizard;
        WizardCollectionElement selectedCategory = (WizardCollectionElement)this.getSingleSelection((IStructuredSelection)this.categoryTreeViewer.getSelection());
        if (selectedCategory != null) {
            this.settings.put(STORE_SELECTED_CATEGORY_ID, selectedCategory.getPath().toString());
        }
        if ((selectedWizard = (WorkbenchWizardElement)this.getSingleSelection((IStructuredSelection)this.wizardSelectionViewer.getSelection())) != null) {
            this.settings.put(STORE_SELECTED_WIZARD_ID, selectedWizard.getID());
        }
    }

    private static final class RootElementProxy
    extends WorkbenchAdapter
    implements IAdaptable {
        private WizardCollectionElement[] elements;
        static /* synthetic */ Class class$0;

        public RootElementProxy(WizardCollectionElement element) {
            this.elements = new WizardCollectionElement[]{element};
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return this.elements;
        }
    }
}

