/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PathVariableDialog;

public class PathVariablesGroup {
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private Shell shell;
    private Table variableTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FontMetrics fontMetrics;
    private boolean multiSelect;
    private int variableType;
    private SortedMap tempPathVariables;
    private Set removedVariableNames;
    private IPathVariableManager pathVariableManager;
    private final Image FILE_IMG = WorkbenchImages.getImage("IMG_OBJ_FILE");
    private final Image FOLDER_IMG = WorkbenchImages.getImage("IMG_OBJ_FOLDER");
    private Image imageUnkown;

    public PathVariablesGroup(boolean multiSelect, int variableType) {
        this.multiSelect = multiSelect;
        this.variableType = variableType;
        this.pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    private void addNewVariable() {
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 1, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        if (dialog.open() == 1) {
            return;
        }
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        if (this.imageUnkown == null) {
            ImageDescriptor descriptor = WorkbenchImages.getImageDescriptorFromPluginID("org.eclipse.ui", "icons/full/obj16/question.gif");
            this.imageUnkown = descriptor.createImage();
        }
        this.initializeDialogUnits((Control)parent);
        this.shell = parent.getShell();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        Label variableLabel = new Label(pageComponent, 16384);
        variableLabel.setText(WorkbenchMessages.getString("PathVariablesBlock.variablesLabel"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        variableLabel.setLayoutData((Object)data);
        variableLabel.setFont(font);
        int tableStyle = 67584;
        if (this.multiSelect) {
            tableStyle |= 2;
        }
        this.variableTable = new Table(pageComponent, tableStyle);
        this.variableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.updateEnabledState();
            }
        });
        data = new GridData(1808);
        data.heightHint = this.variableTable.getItemHeight() * 7;
        this.variableTable.setLayoutData((Object)data);
        this.variableTable.setFont(font);
        this.createButtonGroup(pageComponent);
        this.updateWidgetState(null);
        return pageComponent;
    }

    public void dispose() {
        if (this.imageUnkown != null) {
            this.imageUnkown.dispose();
            this.imageUnkown = null;
        }
    }

    private void editSelectedVariable() {
        TableItem item = this.variableTable.getItem(this.variableTable.getSelectionIndex());
        String variableName = (String)item.getData();
        IPath variableValue = (IPath)this.tempPathVariables.get(variableName);
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 2, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        dialog.setVariableName(variableName);
        dialog.setVariableValue(variableValue.toOSString());
        if (dialog.open() == 1) {
            return;
        }
        this.removedVariableNames.add(variableName);
        this.tempPathVariables.remove(variableName);
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public String[] getSelection() {
        if (this.variableTable == null) {
            return new String[0];
        }
        TableItem[] items = this.variableTable.getSelection();
        String[] variableNames = new String[items.length];
        int i = 0;
        while (i < items.length) {
            variableNames[i] = (String)items[i].getData();
            ++i;
        }
        return variableNames;
    }

    private void createButtonGroup(Composite parent) {
        Font font = parent.getFont();
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(WorkbenchMessages.getString("PathVariablesBlock.addVariableButton"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.addNewVariable();
            }
        });
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(WorkbenchMessages.getString("PathVariablesBlock.editVariableButton"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.editSelectedVariable();
            }
        });
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(WorkbenchMessages.getString("PathVariablesBlock.removeVariableButton"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.removeSelectedVariables();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void initTemporaryState() {
        String[] varNames = this.pathVariableManager.getPathVariableNames();
        this.tempPathVariables.clear();
        int i = 0;
        while (i < varNames.length) {
            boolean isFile;
            IPath value = this.pathVariableManager.getValue(varNames[i]);
            if (value != null && ((isFile = value.toFile().isFile()) && (this.variableType & 1) != 0 || !isFile && (this.variableType & 2) != 0)) {
                this.tempPathVariables.put(varNames[i], value);
            }
            ++i;
        }
        this.removedVariableNames.clear();
    }

    private void updateEnabledState() {
        int itemsSelectedCount = this.variableTable.getSelectionCount();
        this.editButton.setEnabled(itemsSelectedCount == 1);
        this.removeButton.setEnabled(itemsSelectedCount > 0);
    }

    private void updateVariableTable(String selectedVarName) {
        this.variableTable.removeAll();
        int selectedVarIndex = 0;
        Iterator varNames = this.tempPathVariables.keySet().iterator();
        while (varNames.hasNext()) {
            TableItem item = new TableItem(this.variableTable, 0);
            String varName = (String)varNames.next();
            IPath value = (IPath)this.tempPathVariables.get(varName);
            File file = value.toFile();
            item.setText(String.valueOf(varName) + " - " + value.toOSString());
            item.setData((Object)varName);
            item.setImage(file.exists() ? (file.isFile() ? this.FILE_IMG : this.FOLDER_IMG) : this.imageUnkown);
            if (!varName.equals(selectedVarName)) continue;
            selectedVarIndex = this.variableTable.getItemCount() - 1;
        }
        if (this.variableTable.getItemCount() > selectedVarIndex) {
            this.variableTable.setSelection(selectedVarIndex);
        }
    }

    public boolean performOk() {
        try {
            Iterator removed = this.removedVariableNames.iterator();
            while (removed.hasNext()) {
                String removedVariableName = (String)removed.next();
                if (this.tempPathVariables.containsKey(removedVariableName)) continue;
                this.pathVariableManager.setValue(removedVariableName, null);
            }
            Iterator current = this.tempPathVariables.entrySet().iterator();
            while (current.hasNext()) {
                Map.Entry entry = current.next();
                String variableName = (String)entry.getKey();
                IPath variableValue = (IPath)entry.getValue();
                this.pathVariableManager.setValue(variableName, variableValue);
            }
            this.initTemporaryState();
            return true;
        }
        catch (CoreException ce) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)ce.getStatus());
            return false;
        }
    }

    private void removeSelectedVariables() {
        int[] selectedIndices = this.variableTable.getSelectionIndices();
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem selectedItem = this.variableTable.getItem(selectedIndices[i]);
            String varName = (String)selectedItem.getData();
            this.removedVariableNames.add(varName);
            this.tempPathVariables.remove(varName);
            ++i;
        }
        this.updateWidgetState(null);
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fontMetrics, (int)14);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void updateWidgetState(String selectedVarName) {
        this.updateVariableTable(selectedVarName);
        this.updateEnabledState();
    }
}

