/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EmptyPreferencePage;

public class WorkbenchPreferenceNode
extends PreferenceNode {
    private String category;
    private IConfigurationElement configurationElement;
    public static final String ATT_CONTRIBUTOR_CLASS = "class";
    private IWorkbench workbench;

    public WorkbenchPreferenceNode(String nodeId, String nodeLabel, String category, ImageDescriptor nodeImage, IConfigurationElement element, IWorkbench newWorkbench) {
        super(nodeId, nodeLabel, nodeImage, null);
        this.category = category;
        this.configurationElement = element;
        this.workbench = newWorkbench;
    }

    public WorkbenchPreferenceNode(String nodeId, String nodeLabel, String category, ImageDescriptor nodeImage, IWorkbenchPreferencePage preferencePage) {
        super(nodeId, nodeLabel, nodeImage, null);
        this.setPage(preferencePage);
    }

    public void createPage() {
        IWorkbenchPreferencePage page;
        try {
            page = (IWorkbenchPreferencePage)WorkbenchPlugin.createExtension(this.configurationElement, ATT_CONTRIBUTOR_CLASS);
        }
        catch (CoreException e) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("PreferenceNode.errorTitle"), (String)WorkbenchMessages.getString("PreferenceNode.errorMessage"), (IStatus)e.getStatus());
            page = new EmptyPreferencePage();
        }
        page.init(this.workbench);
        if (this.getLabelImage() != null) {
            page.setImageDescriptor(this.getImageDescriptor());
        }
        page.setTitle(this.getLabelText());
        this.setPage(page);
    }

    public String getCategory() {
        return this.category;
    }
}

