/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.ZipFileResourceExporter;

class ZipFileResourceExportOperation
implements IRunnableWithProgress {
    private ZipFileResourceExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private int leadupStartDepth = 0;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean createLeadupStructure = true;
    private boolean generateManifestFile = false;

    public ZipFileResourceExportOperation(List resources, String filename) {
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
    }

    public ZipFileResourceExportOperation(IResource res, String filename) {
        this.resource = res;
        this.destinationFilename = filename;
    }

    public ZipFileResourceExportOperation(IResource res, List resources, String filename) {
        this(res, filename);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (resource.isAccessible()) {
            IResource[] children = ((IContainer)resource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void exportResource(IResource resource) throws InterruptedException {
        if (!resource.isAccessible()) {
            return;
        }
        if (resource.getType() == 1) {
            String destinationName = resource.getFullPath().removeFirstSegments(this.leadupStartDepth).toString();
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)resource, destinationName);
            }
            catch (IOException e) {
                this.addError(WorkbenchMessages.format("ZipExport.errorOnResource", new Object[]{resource.getFullPath()}), e);
            }
            catch (CoreException e) {
                this.addError(WorkbenchMessages.format("ZipExport.errorOnResource", new Object[]{resource.getFullPath()}), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] children = null;
            try {
                children = ((IContainer)resource).members();
            }
            catch (CoreException e) {
                this.addError(WorkbenchMessages.format("ZipExport.errorOnResource", new Object[]{resource.getFullPath()}), e);
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i]);
                ++i;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            IResource currentResource = (IResource)resources.next();
            if (this.resource == null && !this.createLeadupStructure) {
                this.leadupStartDepth = currentResource.getFullPath().segmentCount() - 1;
            }
            this.exportResource(currentResource);
        }
    }

    public List getResult() {
        return this.errorTable;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, WorkbenchMessages.getString("ZipExport.problemEncountered"), null);
    }

    protected void initialize() throws IOException {
        this.exporter = new ZipFileResourceExporter(this.destinationFilename, this.useCompression, this.generateManifestFile);
        if (this.resource == null) {
            this.leadupStartDepth = 1;
        } else {
            this.leadupStartDepth = this.resource.getFullPath().segmentCount();
            if (this.resource.getType() == 1) {
                --this.leadupStartDepth;
            }
            if (this.createLeadupStructure) {
                this.leadupStartDepth = Math.min(1, this.leadupStartDepth);
            }
        }
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.monitor = monitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, String.valueOf(WorkbenchMessages.getString("ZipExport.unableToOpen")) + e.getMessage());
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {}
            monitor.beginTask(WorkbenchMessages.getString("ZipExport.progress"), totalWork);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, String.valueOf(WorkbenchMessages.getString("ZipExport.unableToClose")) + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_7 = null;
        monitor.done();
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setGenerateManifestFile(boolean value) {
        this.generateManifestFile = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }
}

