/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class ExternalEditor {
    private IFile file;
    private EditorDescriptor descriptor;

    public ExternalEditor(IFile newFile, EditorDescriptor editorDescriptor) {
        this.file = newFile;
        this.descriptor = editorDescriptor;
    }

    public void open() throws CoreException {
        Program program = this.descriptor.getProgram();
        if (program != null) {
            String path = new String();
            IPath location = this.file.getLocation();
            if (location != null && program.execute(path = location.toOSString())) {
                return;
            }
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, WorkbenchMessages.format("ExternalEditor.errorMessage", new Object[]{path}), null));
        }
        this.openWithUserDefinedProgram();
    }

    public void openWithUserDefinedProgram() throws CoreException {
        IPath location;
        String programFileName = null;
        IConfigurationElement configurationElement = this.descriptor.getConfigurationElement();
        if (configurationElement != null) {
            URL installURL = configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
            try {
                URL commandURL = new URL(installURL, this.descriptor.getFileName());
                URL localName = Platform.asLocalURL((URL)commandURL);
                File file = new File(localName.getFile());
                if (file.exists()) {
                    programFileName = file.getAbsolutePath();
                }
            }
            catch (IOException iOException) {}
        }
        if (programFileName == null) {
            programFileName = this.descriptor.getFileName();
        }
        if ((location = this.file.getLocation()) == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, WorkbenchMessages.format("ExternalEditor.errorMessage", new Object[]{programFileName}), null));
        }
        String path = location.toOSString();
        try {
            Runtime.getRuntime().exec(new String[]{programFileName, path});
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, WorkbenchMessages.format("ExternalEditor.errorMessage", new Object[]{programFileName}), (Throwable)e));
        }
    }
}

