/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.ProjectImageRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ProjectImageRegistryReader
extends RegistryReader {
    private static final String TAG_IMAGE = "image";
    private static final String ATT_ID = "id";
    private static final String ATT_NATURE_ID = "natureId";
    private static final String ATT_ICON = "icon";
    private ProjectImageRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_IMAGE)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            this.logMissingAttribute(element, ATT_ID);
            return true;
        }
        String natureId = element.getAttribute(ATT_NATURE_ID);
        if (natureId == null) {
            this.logMissingAttribute(element, ATT_NATURE_ID);
            return true;
        }
        String icon = element.getAttribute(ATT_ICON);
        if (icon == null) {
            this.logMissingAttribute(element, ATT_ICON);
            return true;
        }
        ImageDescriptor image = WorkbenchImages.getImageDescriptorFromExtension(element.getDeclaringExtension(), icon);
        if (image != null) {
            this.registry.setNatureImage(natureId, image);
        }
        return true;
    }

    public void readProjectNatureImages(IPluginRegistry in, ProjectImageRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui", "projectNatureImages");
    }
}

