/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;

public class ViewDescriptor
implements IViewDescriptor {
    private String id;
    private ImageDescriptor imageDescriptor;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ACCELERATOR = "accelerator";
    private static final String ATT_ICON = "icon";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CLASS = "class";
    private static final String ATT_RATIO = "fastViewWidthRatio";
    private String label;
    private String accelerator;
    private String className;
    private IConfigurationElement configElement;
    private String[] categoryPath;
    private float fastViewWidthRatio;

    public ViewDescriptor(IConfigurationElement e) throws CoreException {
        this.configElement = e;
        this.loadFromExtension();
    }

    public IViewPart createView() throws CoreException {
        Object obj = WorkbenchPlugin.createExtension(this.configElement, ATT_CLASS);
        return (IViewPart)obj;
    }

    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getID() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.configElement.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        this.imageDescriptor = WorkbenchImages.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), iconName);
        return this.imageDescriptor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public float getFastViewWidthRatio() {
        return this.fastViewWidthRatio;
    }

    private void loadFromExtension() throws CoreException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.label = this.configElement.getAttribute(ATT_NAME);
        this.accelerator = this.configElement.getAttribute(ATT_ACCELERATOR);
        this.className = this.configElement.getAttribute(ATT_CLASS);
        String category = this.configElement.getAttribute(ATT_CATEGORY);
        String ratio = this.configElement.getAttribute(ATT_RATIO);
        if (this.label == null || this.className == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
        if (category != null) {
            StringTokenizer stok = new StringTokenizer(category, "/");
            this.categoryPath = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                this.categoryPath[i] = stok.nextToken();
                ++i;
            }
        }
        if (ratio != null) {
            try {
                this.fastViewWidthRatio = new Float(ratio).floatValue();
                if (this.fastViewWidthRatio > 0.95f) {
                    this.fastViewWidthRatio = 0.95f;
                }
                if (this.fastViewWidthRatio < 0.05f) {
                    this.fastViewWidthRatio = 0.05f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fastViewWidthRatio = 0.3f;
            }
        } else {
            this.fastViewWidthRatio = 0.3f;
        }
    }

    public String toString() {
        return "View(" + this.getID() + ")";
    }
}

