/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

class WizardZipFileResourceImportPage1
extends WizardFileSystemResourceImportPage1
implements Listener {
    private ZipFileStructureProvider providerCache;
    ZipFileStructureProvider currentProvider;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_IMPORT_ALL_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_IMPORT_ALL_ENTRIES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardZipFileResourceImportPage1.STORE_SELECTED_TYPES_ID";

    public WizardZipFileResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("zipFileImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.getString("ZipExport.exportTitle"));
        this.setDescription(DataTransferMessages.getString("ZipImport.description"));
    }

    public boolean cancel() {
        this.clearProviderCache();
        return true;
    }

    protected void clearProviderCache() {
        if (this.providerCache != null) {
            this.closeZipFile(this.providerCache.getZipFile());
            this.providerCache = null;
        }
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.format("ZipImport.couldNotClose", new Object[]{file.getName()}));
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp(this.getControl(), "org.eclipse.ui.zip_file_import_wizard_page");
    }

    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingResourcesCheckbox = new Button(parent, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.getString("FileImport.overwriteExisting"));
        this.overwriteExistingResourcesCheckbox.setFont(parent.getFont());
    }

    protected boolean ensureSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.clearProviderCache();
        return true;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFiles(WizardZipFileResourceImportPage1.this.currentProvider).getChildren(element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        ZipFileStructureProvider provider;
        ZipFile sourceFile = this.getSpecifiedSourceFile();
        if (sourceFile == null) {
            this.currentProvider = null;
            return null;
        }
        this.currentProvider = provider = this.getStructureProvider(sourceFile);
        return this.selectFiles(provider.getRoot(), provider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFolders(WizardZipFileResourceImportPage1.this.currentProvider).getChildren(element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    if (element.isPopulated()) {
                        return this.getChildren(element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected String getSourceLabel() {
        return DataTransferMessages.getString("ZipExport.destinationLabel");
    }

    protected ZipFile getSpecifiedSourceFile() {
        return this.getSpecifiedSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.badFormat"));
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.couldNotRead"));
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected ZipFileStructureProvider getStructureProvider(ZipFile targetZip) {
        if (this.providerCache == null) {
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().getName().equals(targetZip.getName())) {
            this.clearProviderCache();
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().equals(targetZip)) {
            this.closeZipFile(targetZip);
        }
        return this.providerCache;
    }

    protected void handleSourceBrowseButtonPressed() {
        ZipFile sourceFile;
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && (sourceFile = this.getSpecifiedSourceFile(selectedFile)) != null) {
            this.closeZipFile(sourceFile);
            this.setSourceName(selectedFile);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResources(List fileSystemObjects) {
        ZipFile zipFile = this.getSpecifiedSourceFile();
        ZipFileStructureProvider structureProvider = this.getStructureProvider(zipFile);
        ImportOperation operation = new ImportOperation(this.getContainerFullPath(), structureProvider.getRoot(), structureProvider, this, fileSystemObjects);
        operation.setContext(this.getShell());
        boolean result = this.executeImportOperation(operation);
        this.closeZipFile(zipFile);
        return result;
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void resetSelection() {
        super.resetSelection();
        this.setAllSelections(true);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    protected boolean validateSourceGroup() {
        if (this.currentProvider == null) {
            this.setMessage(WizardFileSystemResourceImportPage1.SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }
}

