/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api;

import engineer.nightowl.sonos.api.SonosApiConfiguration;
import engineer.nightowl.sonos.api.resource.AuthorizeResource;
import engineer.nightowl.sonos.api.resource.FavoriteResource;
import engineer.nightowl.sonos.api.resource.GroupResource;
import engineer.nightowl.sonos.api.resource.GroupVolumeResource;
import engineer.nightowl.sonos.api.resource.HomeTheaterResource;
import engineer.nightowl.sonos.api.resource.HouseholdResource;
import engineer.nightowl.sonos.api.resource.MusicServiceAccountsResource;
import engineer.nightowl.sonos.api.resource.PlaybackMetadataResource;
import engineer.nightowl.sonos.api.resource.PlaybackResource;
import engineer.nightowl.sonos.api.resource.PlaybackSessionResource;
import engineer.nightowl.sonos.api.resource.PlayerVolumeResource;
import java.io.IOException;
import java.util.Properties;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonosApiClient {
    private final AuthorizeResource authorizeResource;
    private final FavoriteResource favoriteResource;
    private final GroupResource groupResource;
    private final GroupVolumeResource groupVolumeResource;
    private final HomeTheaterResource homeTheaterResource;
    private final HouseholdResource householdResource;
    private final MusicServiceAccountsResource musicServiceAccountsResource;
    private final PlaybackMetadataResource playbackMetadataResource;
    private final PlaybackResource playbackResource;
    private final PlaybackSessionResource playbackSessionResource;
    private final PlayerVolumeResource playerVolumeResource;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Properties properties = new Properties();
    private SonosApiConfiguration configuration;
    private CloseableHttpClient httpClient;

    public SonosApiClient(SonosApiConfiguration configuration) {
        this.loadProperties();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialising sonos-api-java:{}", (Object)this.properties.getProperty("sonosapijava.version"));
        }
        this.configuration = configuration;
        this.httpClient = this.generateHttpClient();
        this.authorizeResource = new AuthorizeResource(this);
        this.favoriteResource = new FavoriteResource(this);
        this.groupResource = new GroupResource(this);
        this.groupVolumeResource = new GroupVolumeResource(this);
        this.homeTheaterResource = new HomeTheaterResource(this);
        this.householdResource = new HouseholdResource(this);
        this.musicServiceAccountsResource = new MusicServiceAccountsResource(this);
        this.playbackMetadataResource = new PlaybackMetadataResource(this);
        this.playbackResource = new PlaybackResource(this);
        this.playbackSessionResource = new PlaybackSessionResource(this);
        this.playerVolumeResource = new PlayerVolumeResource(this);
    }

    private CloseableHttpClient generateHttpClient() {
        return HttpClientBuilder.create().build();
    }

    public void closeHttpClient() {
        try {
            this.httpClient.close();
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to close HTTP client", (Throwable)ioe);
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private void loadProperties() {
        try {
            this.properties.load(this.getClass().getClassLoader().getResourceAsStream("sonosapijava.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.logger.error("Unable to load project.properties from classpath");
        }
    }

    public SonosApiConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SonosApiConfiguration configuration) {
        this.configuration = configuration;
    }

    public AuthorizeResource authorize() {
        return this.authorizeResource;
    }

    public FavoriteResource favorite() {
        return this.favoriteResource;
    }

    public GroupResource group() {
        return this.groupResource;
    }

    public GroupVolumeResource groupVolumeResource() {
        return this.groupVolumeResource;
    }

    public HomeTheaterResource homeTheater() {
        return this.homeTheaterResource;
    }

    public HouseholdResource household() {
        return this.householdResource;
    }

    public MusicServiceAccountsResource musicServiceAccounts() {
        return this.musicServiceAccountsResource;
    }

    public PlaybackMetadataResource playbackMetadata() {
        return this.playbackMetadataResource;
    }

    public PlaybackResource playback() {
        return this.playbackResource;
    }

    public PlaybackSessionResource playbackSession() {
        return this.playbackSessionResource;
    }

    public PlayerVolumeResource playerVolume() {
        return this.playerVolumeResource;
    }
}

