/*
 * Decompiled with CFR 0.152.
 */
package engineer.nightowl.sonos.api.resource;

import engineer.nightowl.sonos.api.SonosApiClient;
import engineer.nightowl.sonos.api.domain.SonosGroupVolume;
import engineer.nightowl.sonos.api.domain.SonosSuccess;
import engineer.nightowl.sonos.api.exception.SonosApiClientException;
import engineer.nightowl.sonos.api.exception.SonosApiError;
import engineer.nightowl.sonos.api.resource.BaseResource;
import engineer.nightowl.sonos.api.specs.Subscribable;
import java.util.HashMap;

public class GroupVolumeResource
extends BaseResource
implements Subscribable {
    public GroupVolumeResource(SonosApiClient apiClient) {
        super(apiClient);
    }

    public SonosGroupVolume getVolume(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.getFromApi(SonosGroupVolume.class, clientToken, String.format("/v1/groups/%s/groupVolume", groupId));
    }

    public SonosSuccess setVolume(String clientToken, String groupId, Integer volume) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(volume);
        HashMap<String, Integer> payload = new HashMap<String, Integer>();
        payload.put("volume", volume);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/groupVolume", groupId), payload);
    }

    public SonosSuccess setRelativeVolume(String clientToken, String groupId, Integer volumeDelta) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(volumeDelta);
        HashMap<String, Integer> payload = new HashMap<String, Integer>();
        payload.put("volumeDelta", volumeDelta);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/groupVolume/relative", groupId), payload);
    }

    public SonosSuccess setMute(String clientToken, String groupId, Boolean isMuted) throws SonosApiClientException, SonosApiError {
        this.validateNotNull(isMuted);
        HashMap<String, Boolean> payload = new HashMap<String, Boolean>();
        payload.put("muted", isMuted);
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/groupVolume/mute", groupId), payload);
    }

    @Override
    public SonosSuccess subscribe(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.postToApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/groupVolume/subscription", groupId));
    }

    @Override
    public SonosSuccess unsubscribe(String clientToken, String groupId) throws SonosApiClientException, SonosApiError {
        return this.deleteFromApi(SonosSuccess.class, clientToken, String.format("/v1/groups/%s/groupVolume/subscription", groupId));
    }
}

