/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableAngleValue
extends AnimatableNumberValue {
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected short unit;

    public AnimatableAngleValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableAngleValue(AnimationTarget target, float v, short unit) {
        super(target, v);
        this.unit = unit;
    }

    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to2, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableAngleValue res = result2 == null ? new AnimatableAngleValue(this.target) : (AnimatableAngleValue)result2;
        float v = this.value;
        short u = this.unit;
        if (to2 != null) {
            AnimatableAngleValue toAngle = (AnimatableAngleValue)to2;
            if (toAngle.unit != u) {
                v = AnimatableAngleValue.rad(v, u);
                v += interpolation * (AnimatableAngleValue.rad(toAngle.value, toAngle.unit) - v);
                u = 3;
            } else {
                v += interpolation * (toAngle.value - v);
            }
        }
        if (accumulation != null) {
            AnimatableAngleValue accAngle = (AnimatableAngleValue)accumulation;
            if (accAngle.unit != u) {
                v += (float)multiplier * AnimatableAngleValue.rad(accAngle.value, accAngle.unit);
                u = 3;
            } else {
                v += (float)multiplier * accAngle.value;
            }
        }
        if (res.value != v || res.unit != u) {
            res.value = v;
            res.unit = u;
            res.hasChanged = true;
        }
        return res;
    }

    public short getUnit() {
        return this.unit;
    }

    public float distanceTo(AnimatableValue other) {
        AnimatableAngleValue o = (AnimatableAngleValue)other;
        return Math.abs(AnimatableAngleValue.rad(this.value, this.unit) - AnimatableAngleValue.rad(o.value, o.unit));
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableAngleValue(this.target, 0.0f, 1);
    }

    public String getCssText() {
        return super.getCssText() + UNITS[this.unit];
    }

    public static float rad(float v, short unit) {
        switch (unit) {
            case 3: {
                return v;
            }
            case 4: {
                return (float)Math.PI * v / 200.0f;
            }
        }
        return (float)Math.PI * v / 180.0f;
    }
}

