/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableBooleanValue
extends AnimatableValue {
    protected boolean value;

    protected AnimatableBooleanValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableBooleanValue(AnimationTarget target, boolean b) {
        super(target);
        this.value = b;
    }

    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to2, float interpolation, AnimatableValue accumulation, int multiplier) {
        boolean newValue;
        AnimatableBooleanValue res = result2 == null ? new AnimatableBooleanValue(this.target) : (AnimatableBooleanValue)result2;
        if (to2 != null && (double)interpolation >= 0.5) {
            AnimatableBooleanValue toValue = (AnimatableBooleanValue)to2;
            newValue = toValue.value;
        } else {
            newValue = this.value;
        }
        if (res.value != newValue) {
            res.value = newValue;
            res.hasChanged = true;
        }
        return res;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableBooleanValue(this.target, false);
    }

    public String getCssText() {
        return this.value ? "true" : "false";
    }
}

