/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class HashTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public HashTable() {
        this.table = new Entry[11];
    }

    public HashTable(int c) {
        this.table = new Entry[c];
    }

    public HashTable(HashTable t) {
        this.count = t.count;
        this.table = new Entry[t.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = t.table[i];
            Entry n = null;
            if (e == null) continue;
            this.table[i] = n = new Entry(e.hash, e.key, e.value, null);
            e = e.next;
            while (e != null) {
                n = n.next = new Entry(e.hash, e.key, e.value, null);
                e = e.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public Object get(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(Object key, Object value2) {
        Entry e;
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e2 = this.table[index2];
        while (e2 != null) {
            if (e2.hash == hash2 && (e2.key == null && key == null || e2.key != null && e2.key.equals(key))) {
                Object old = e2.value;
                e2.value = value2;
                return old;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = e = new Entry(hash2, key, value2, this.table[index2]);
        return null;
    }

    public Object remove(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry p = null;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                Object result2 = e.value;
                if (p == null) {
                    this.table[index2] = e.next;
                } else {
                    p.next = e.next;
                }
                --this.count;
                return result2;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    public Object key(int index2) {
        if (index2 < 0 || index2 >= this.count) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            if (e == null) continue;
            do {
                if (j++ != index2) continue;
                return e.key;
            } while ((e = e.next) != null);
        }
        return null;
    }

    public Object item(int index2) {
        if (index2 < 0 || index2 >= this.count) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            if (e == null) continue;
            do {
                if (j++ != index2) continue;
                return e.value;
            } while ((e = e.next) != null);
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = e.hash % this.table.length;
                e.next = this.table[index2];
                this.table[index2] = e;
            }
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        public Entry(int hash2, Object key, Object value2, Entry next2) {
            this.hash = hash2;
            this.key = key;
            this.value = value2;
            this.next = next2;
        }
    }
}

