/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);
    static /* synthetic */ Class class$org$apache$batik$script$InterpreterFactory;

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document2, String language2) {
        InterpreterFactory factory = (InterpreterFactory)this.factories.get(language2);
        if (factory == null) {
            return null;
        }
        Interpreter interpreter = null;
        SVGOMDocument svgDoc = (SVGOMDocument)document2;
        try {
            URL url = new URL(svgDoc.getDocumentURI());
            interpreter = factory.createInterpreter(url, svgDoc.isSVG12());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (interpreter == null) {
            return null;
        }
        if (document2 != null) {
            interpreter.bindObject(BIND_NAME_DOCUMENT, document2);
        }
        return interpreter;
    }

    public void putInterpreterFactory(String language2, InterpreterFactory factory) {
        this.factories.put(language2, factory);
    }

    public void removeInterpreterFactory(String language2) {
        this.factories.remove(language2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Iterator iter2 = Service.providers(class$org$apache$batik$script$InterpreterFactory == null ? (class$org$apache$batik$script$InterpreterFactory = InterpreterPool.class$("org.apache.batik.script.InterpreterFactory")) : class$org$apache$batik$script$InterpreterFactory);
        while (iter2.hasNext()) {
            InterpreterFactory factory = null;
            factory = (InterpreterFactory)iter2.next();
            String[] mimeTypes = factory.getMimeTypes();
            for (int i = 0; i < mimeTypes.length; ++i) {
                defaultFactories.put(mimeTypes[i], factory);
            }
        }
    }
}

