/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.io.IOException;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.DOMImplementationKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_CLASSNAME = new StringKey();
    public static final TranscodingHints.Key KEY_XML_PARSER_VALIDATING = new BooleanKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey();
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplementationKey();

    protected XMLAbstractTranscoder() {
        this.hints.put(KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
    }

    public void transcode(TranscoderInput input2, TranscoderOutput output) throws TranscoderException {
        Document document2 = null;
        String uri = input2.getURI();
        if (input2.getDocument() != null) {
            document2 = input2.getDocument();
        } else {
            String parserClassname = (String)this.hints.get(KEY_XML_PARSER_CLASSNAME);
            String namespaceURI = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
            String documentElement = (String)this.hints.get(KEY_DOCUMENT_ELEMENT);
            DOMImplementation domImpl = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
            if (parserClassname == null) {
                parserClassname = XMLResourceDescriptor.getXMLParserClassName();
            }
            if (domImpl == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOM_IMPLEMENTATION"));
                return;
            }
            if (namespaceURI == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"));
                return;
            }
            if (documentElement == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT"));
                return;
            }
            DocumentFactory f = this.createDocumentFactory(domImpl, parserClassname);
            boolean b = (Boolean)this.hints.get(KEY_XML_PARSER_VALIDATING);
            f.setValidating(b);
            try {
                if (input2.getInputStream() != null) {
                    document2 = f.createDocument(namespaceURI, documentElement, input2.getURI(), input2.getInputStream());
                } else if (input2.getReader() != null) {
                    document2 = f.createDocument(namespaceURI, documentElement, input2.getURI(), input2.getReader());
                } else if (input2.getXMLReader() != null) {
                    document2 = f.createDocument(namespaceURI, documentElement, input2.getURI(), input2.getXMLReader());
                } else if (uri != null) {
                    document2 = f.createDocument(namespaceURI, documentElement, uri);
                }
            }
            catch (DOMException ex) {
                this.handler.fatalError(new TranscoderException(ex));
            }
            catch (IOException ex) {
                this.handler.fatalError(new TranscoderException(ex));
            }
        }
        if (document2 != null) {
            try {
                this.transcode(document2, uri, output);
            }
            catch (TranscoderException ex) {
                this.handler.fatalError(ex);
                return;
            }
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        return new SAXDocumentFactory(domImpl, parserClassname);
    }

    protected abstract void transcode(Document var1, String var2, TranscoderOutput var3) throws TranscoderException;
}

