/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.apps;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.parser.MODCAParser;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public class FontPatternExtractor {
    private PrintStream printStream = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file, File targetDir) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            UnparsedStructuredField strucField;
            MODCAParser parser = new MODCAParser(in);
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            while ((strucField = parser.readNextStructuredField()) != null) {
                if (strucField.getSfTypeID() != 13889161) continue;
                byte[] sfData = strucField.getData();
                this.println(strucField.toString());
                HexDump.dump(sfData, 0L, this.printStream, 0);
                baout.write(sfData);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(baout.toByteArray());
            DataInputStream din = new DataInputStream(bin);
            long len = (long)din.readInt() & 0xFFFFFFFFL;
            this.println("Length: " + len);
            din.skip(4L);
            int tidLen = din.readUnsignedShort() - 2;
            byte[] tid = new byte[tidLen];
            din.readFully(tid);
            String filename = new String(tid, "ISO-8859-1");
            int asciiCount1 = this.countUSAsciiCharacters(filename);
            String filenameEBCDIC = new String(tid, "Cp1146");
            int asciiCount2 = this.countUSAsciiCharacters(filenameEBCDIC);
            this.println("TID: " + filename + " " + filenameEBCDIC);
            if (asciiCount2 > asciiCount1) {
                filename = filenameEBCDIC;
            }
            if (!filename.toLowerCase().endsWith(".pfb")) {
                filename = filename + ".pfb";
            }
            this.println("Output filename: " + filename);
            File out = new File(targetDir, filename);
            FileOutputStream fout = new FileOutputStream(out);
            try {
                IOUtils.copyLarge(din, fout);
            }
            finally {
                IOUtils.closeQuietly(fout);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private void println(String s2) {
        this.printStream.println(s2);
    }

    private void println() {
        this.printStream.println();
    }

    private int countUSAsciiCharacters(String filename) {
        int count2 = 0;
        int c = filename.length();
        for (int i = 0; i < c; ++i) {
            if (filename.charAt(i) >= '\u0080') continue;
            ++count2;
        }
        return count2;
    }

    public static void main(String[] args) {
        try {
            FontPatternExtractor app = new FontPatternExtractor();
            app.println("Font Pattern Extractor");
            app.println();
            if (args.length > 0) {
                String filename = args[0];
                File file = new File(filename);
                File targetDir = file.getParentFile();
                if (args.length > 1) {
                    targetDir = new File(args[1]);
                    targetDir.mkdirs();
                }
                app.extract(file, targetDir);
            } else {
                app.println("This tool tries to extract the PFB file from an AFP outline font.");
                app.println();
                app.println("Usage: Java -cp ... " + FontPatternExtractor.class.getName() + " <afp-font-file> [<target-dir>]");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

