/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesRoman
extends Base14Font {
    private static final String fontName = "Times-Roman";
    private static final String fullName = "Times Roman";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 662;
    private static final int xHeight = 450;
    private static final int ascender = 683;
    private static final int descender = -217;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesRoman() {
        this(false);
    }

    public TimesRoman(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size2) {
        return size2 * 683;
    }

    public int getCapHeight(int size2) {
        return size2 * 662;
    }

    public int getDescender(int size2) {
        return size2 * -217;
    }

    public int getXHeight(int size2) {
        return size2 * 450;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size2) {
        return size2 * width[i];
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        TimesRoman.width[65] = 722;
        TimesRoman.width[198] = 889;
        TimesRoman.width[193] = 722;
        TimesRoman.width[194] = 722;
        TimesRoman.width[196] = 722;
        TimesRoman.width[192] = 722;
        TimesRoman.width[197] = 722;
        TimesRoman.width[195] = 722;
        TimesRoman.width[66] = 667;
        TimesRoman.width[67] = 667;
        TimesRoman.width[199] = 667;
        TimesRoman.width[68] = 722;
        TimesRoman.width[69] = 611;
        TimesRoman.width[201] = 611;
        TimesRoman.width[202] = 611;
        TimesRoman.width[203] = 611;
        TimesRoman.width[200] = 611;
        TimesRoman.width[208] = 722;
        TimesRoman.width[128] = 500;
        TimesRoman.width[70] = 556;
        TimesRoman.width[71] = 722;
        TimesRoman.width[72] = 722;
        TimesRoman.width[73] = 333;
        TimesRoman.width[205] = 333;
        TimesRoman.width[206] = 333;
        TimesRoman.width[207] = 333;
        TimesRoman.width[204] = 333;
        TimesRoman.width[74] = 389;
        TimesRoman.width[75] = 722;
        TimesRoman.width[76] = 611;
        TimesRoman.width[77] = 889;
        TimesRoman.width[78] = 722;
        TimesRoman.width[209] = 722;
        TimesRoman.width[79] = 722;
        TimesRoman.width[140] = 889;
        TimesRoman.width[211] = 722;
        TimesRoman.width[212] = 722;
        TimesRoman.width[214] = 722;
        TimesRoman.width[210] = 722;
        TimesRoman.width[216] = 722;
        TimesRoman.width[213] = 722;
        TimesRoman.width[80] = 556;
        TimesRoman.width[81] = 722;
        TimesRoman.width[82] = 667;
        TimesRoman.width[83] = 556;
        TimesRoman.width[138] = 556;
        TimesRoman.width[84] = 611;
        TimesRoman.width[222] = 556;
        TimesRoman.width[85] = 722;
        TimesRoman.width[218] = 722;
        TimesRoman.width[219] = 722;
        TimesRoman.width[220] = 722;
        TimesRoman.width[217] = 722;
        TimesRoman.width[86] = 722;
        TimesRoman.width[87] = 944;
        TimesRoman.width[88] = 722;
        TimesRoman.width[89] = 722;
        TimesRoman.width[221] = 722;
        TimesRoman.width[159] = 722;
        TimesRoman.width[90] = 611;
        TimesRoman.width[142] = 611;
        TimesRoman.width[97] = 444;
        TimesRoman.width[225] = 444;
        TimesRoman.width[226] = 444;
        TimesRoman.width[180] = 333;
        TimesRoman.width[228] = 444;
        TimesRoman.width[230] = 667;
        TimesRoman.width[224] = 444;
        TimesRoman.width[38] = 778;
        TimesRoman.width[229] = 444;
        TimesRoman.width[94] = 469;
        TimesRoman.width[126] = 541;
        TimesRoman.width[42] = 500;
        TimesRoman.width[64] = 921;
        TimesRoman.width[227] = 444;
        TimesRoman.width[98] = 500;
        TimesRoman.width[92] = 278;
        TimesRoman.width[124] = 200;
        TimesRoman.width[123] = 480;
        TimesRoman.width[125] = 480;
        TimesRoman.width[91] = 333;
        TimesRoman.width[93] = 333;
        TimesRoman.width[166] = 200;
        TimesRoman.width[149] = 350;
        TimesRoman.width[99] = 444;
        TimesRoman.width[231] = 444;
        TimesRoman.width[184] = 333;
        TimesRoman.width[162] = 500;
        TimesRoman.width[136] = 333;
        TimesRoman.width[58] = 278;
        TimesRoman.width[44] = 250;
        TimesRoman.width[169] = 760;
        TimesRoman.width[164] = 500;
        TimesRoman.width[100] = 500;
        TimesRoman.width[134] = 500;
        TimesRoman.width[135] = 500;
        TimesRoman.width[176] = 400;
        TimesRoman.width[168] = 333;
        TimesRoman.width[247] = 564;
        TimesRoman.width[36] = 500;
        TimesRoman.width[101] = 444;
        TimesRoman.width[233] = 444;
        TimesRoman.width[234] = 444;
        TimesRoman.width[235] = 444;
        TimesRoman.width[232] = 444;
        TimesRoman.width[56] = 500;
        TimesRoman.width[133] = 1000;
        TimesRoman.width[151] = 1000;
        TimesRoman.width[150] = 500;
        TimesRoman.width[61] = 564;
        TimesRoman.width[240] = 500;
        TimesRoman.width[33] = 333;
        TimesRoman.width[161] = 333;
        TimesRoman.width[102] = 333;
        TimesRoman.width[53] = 500;
        TimesRoman.width[131] = 500;
        TimesRoman.width[52] = 500;
        TimesRoman.width[103] = 500;
        TimesRoman.width[223] = 500;
        TimesRoman.width[96] = 333;
        TimesRoman.width[62] = 564;
        TimesRoman.width[171] = 500;
        TimesRoman.width[187] = 500;
        TimesRoman.width[139] = 333;
        TimesRoman.width[155] = 333;
        TimesRoman.width[104] = 500;
        TimesRoman.width[45] = 333;
        TimesRoman.width[105] = 278;
        TimesRoman.width[237] = 278;
        TimesRoman.width[238] = 278;
        TimesRoman.width[239] = 278;
        TimesRoman.width[236] = 278;
        TimesRoman.width[106] = 278;
        TimesRoman.width[107] = 500;
        TimesRoman.width[108] = 278;
        TimesRoman.width[60] = 564;
        TimesRoman.width[172] = 564;
        TimesRoman.width[109] = 778;
        TimesRoman.width[175] = 333;
        TimesRoman.width[181] = 500;
        TimesRoman.width[215] = 564;
        TimesRoman.width[110] = 500;
        TimesRoman.width[57] = 500;
        TimesRoman.width[241] = 500;
        TimesRoman.width[35] = 500;
        TimesRoman.width[111] = 500;
        TimesRoman.width[243] = 500;
        TimesRoman.width[244] = 500;
        TimesRoman.width[246] = 500;
        TimesRoman.width[156] = 722;
        TimesRoman.width[242] = 500;
        TimesRoman.width[49] = 500;
        TimesRoman.width[189] = 750;
        TimesRoman.width[188] = 750;
        TimesRoman.width[185] = 300;
        TimesRoman.width[170] = 276;
        TimesRoman.width[186] = 310;
        TimesRoman.width[248] = 500;
        TimesRoman.width[245] = 500;
        TimesRoman.width[112] = 500;
        TimesRoman.width[182] = 453;
        TimesRoman.width[40] = 333;
        TimesRoman.width[41] = 333;
        TimesRoman.width[37] = 833;
        TimesRoman.width[46] = 250;
        TimesRoman.width[183] = 250;
        TimesRoman.width[137] = 1000;
        TimesRoman.width[43] = 564;
        TimesRoman.width[177] = 564;
        TimesRoman.width[113] = 500;
        TimesRoman.width[63] = 444;
        TimesRoman.width[191] = 444;
        TimesRoman.width[34] = 408;
        TimesRoman.width[132] = 444;
        TimesRoman.width[147] = 444;
        TimesRoman.width[148] = 444;
        TimesRoman.width[145] = 333;
        TimesRoman.width[146] = 333;
        TimesRoman.width[130] = 333;
        TimesRoman.width[39] = 180;
        TimesRoman.width[114] = 333;
        TimesRoman.width[174] = 760;
        TimesRoman.width[115] = 389;
        TimesRoman.width[154] = 389;
        TimesRoman.width[167] = 500;
        TimesRoman.width[59] = 278;
        TimesRoman.width[55] = 500;
        TimesRoman.width[54] = 500;
        TimesRoman.width[47] = 278;
        TimesRoman.width[32] = 250;
        TimesRoman.width[163] = 500;
        TimesRoman.width[116] = 278;
        TimesRoman.width[254] = 500;
        TimesRoman.width[51] = 500;
        TimesRoman.width[190] = 750;
        TimesRoman.width[179] = 300;
        TimesRoman.width[152] = 333;
        TimesRoman.width[153] = 980;
        TimesRoman.width[50] = 500;
        TimesRoman.width[178] = 300;
        TimesRoman.width[117] = 500;
        TimesRoman.width[250] = 500;
        TimesRoman.width[251] = 500;
        TimesRoman.width[252] = 500;
        TimesRoman.width[249] = 500;
        TimesRoman.width[95] = 500;
        TimesRoman.width[118] = 500;
        TimesRoman.width[119] = 722;
        TimesRoman.width[120] = 500;
        TimesRoman.width[121] = 500;
        TimesRoman.width[253] = 500;
        TimesRoman.width[255] = 500;
        TimesRoman.width[165] = 500;
        TimesRoman.width[122] = 444;
        TimesRoman.width[158] = 444;
        TimesRoman.width[48] = 500;
        kerning = new HashMap();
        Integer first = new Integer(79);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(65);
        pairs.put(second, new Integer(-35));
        second = new Integer(87);
        pairs.put(second, new Integer(-35));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(107);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-10));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(-15));
        second = new Integer(65);
        pairs.put(second, new Integer(-92));
        second = new Integer(46);
        pairs.put(second, new Integer(-111));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-111));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-129));
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(58);
        pairs.put(second, new Integer(-74));
        second = new Integer(71);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(-129));
        second = new Integer(59);
        pairs.put(second, new Integer(-74));
        second = new Integer(45);
        pairs.put(second, new Integer(-100));
        second = new Integer(105);
        pairs.put(second, new Integer(-60));
        second = new Integer(65);
        pairs.put(second, new Integer(-135));
        second = new Integer(97);
        pairs.put(second, new Integer(-111));
        second = new Integer(117);
        pairs.put(second, new Integer(-75));
        second = new Integer(46);
        pairs.put(second, new Integer(-129));
        second = new Integer(101);
        pairs.put(second, new Integer(-111));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(97);
        pairs.put(second, new Integer(-25));
        second = new Integer(46);
        pairs.put(second, new Integer(-65));
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(-65));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-55));
        second = new Integer(87);
        pairs.put(second, new Integer(-30));
        second = new Integer(147);
        pairs.put(second, new Integer(0));
        second = new Integer(89);
        pairs.put(second, new Integer(-90));
        second = new Integer(84);
        pairs.put(second, new Integer(-18));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-15));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(-15));
        second = new Integer(65);
        pairs.put(second, new Integer(-74));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(100);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(0));
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(83);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-55));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(100);
        pairs.put(second, new Integer(-50));
        second = new Integer(32);
        pairs.put(second, new Integer(-74));
        second = new Integer(146);
        pairs.put(second, new Integer(-74));
        second = new Integer(114);
        pairs.put(second, new Integer(-50));
        second = new Integer(116);
        pairs.put(second, new Integer(-18));
        second = new Integer(108);
        pairs.put(second, new Integer(-10));
        second = new Integer(115);
        pairs.put(second, new Integer(-55));
        second = new Integer(118);
        pairs.put(second, new Integer(-50));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(-10));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-65));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-65));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-35));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(117);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-25));
        second = new Integer(101);
        pairs.put(second, new Integer(-25));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-55));
        second = new Integer(85);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-65));
        second = new Integer(84);
        pairs.put(second, new Integer(-60));
        second = new Integer(86);
        pairs.put(second, new Integer(-80));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(145);
        pairs.put(second, new Integer(-74));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(-5));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-35));
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-70));
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        second = new Integer(146);
        pairs.put(second, new Integer(-70));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(105);
        pairs.put(second, new Integer(-20));
        second = new Integer(146);
        pairs.put(second, new Integer(55));
        second = new Integer(97);
        pairs.put(second, new Integer(-10));
        second = new Integer(102);
        pairs.put(second, new Integer(-25));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-18));
        second = new Integer(119);
        pairs.put(second, new Integer(-80));
        second = new Integer(58);
        pairs.put(second, new Integer(-50));
        second = new Integer(114);
        pairs.put(second, new Integer(-35));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-74));
        second = new Integer(59);
        pairs.put(second, new Integer(-55));
        second = new Integer(45);
        pairs.put(second, new Integer(-92));
        second = new Integer(105);
        pairs.put(second, new Integer(-35));
        second = new Integer(65);
        pairs.put(second, new Integer(-93));
        second = new Integer(97);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-45));
        second = new Integer(121);
        pairs.put(second, new Integer(-80));
        second = new Integer(46);
        pairs.put(second, new Integer(-74));
        second = new Integer(101);
        pairs.put(second, new Integer(-70));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-65));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-65));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-25));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(-15));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(120);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-25));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(0));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-10));
        second = new Integer(58);
        pairs.put(second, new Integer(-37));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        second = new Integer(59);
        pairs.put(second, new Integer(-37));
        second = new Integer(45);
        pairs.put(second, new Integer(-65));
        second = new Integer(105);
        pairs.put(second, new Integer(-40));
        second = new Integer(65);
        pairs.put(second, new Integer(-120));
        second = new Integer(97);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-50));
        second = new Integer(121);
        pairs.put(second, new Integer(-73));
        second = new Integer(46);
        pairs.put(second, new Integer(-92));
        second = new Integer(101);
        pairs.put(second, new Integer(-80));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-5));
        first = new Integer(71);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(105);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(118);
        pairs.put(second, new Integer(-25));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-55));
        second = new Integer(146);
        pairs.put(second, new Integer(-111));
        second = new Integer(119);
        pairs.put(second, new Integer(-92));
        second = new Integer(87);
        pairs.put(second, new Integer(-90));
        second = new Integer(67);
        pairs.put(second, new Integer(-40));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(81);
        pairs.put(second, new Integer(-55));
        second = new Integer(71);
        pairs.put(second, new Integer(-40));
        second = new Integer(86);
        pairs.put(second, new Integer(-135));
        second = new Integer(118);
        pairs.put(second, new Integer(-74));
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(85);
        pairs.put(second, new Integer(-55));
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(89);
        pairs.put(second, new Integer(-105));
        second = new Integer(121);
        pairs.put(second, new Integer(-92));
        second = new Integer(84);
        pairs.put(second, new Integer(-111));
        first = new Integer(147);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        first = new Integer(78);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-35));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-25));
        second = new Integer(121);
        pairs.put(second, new Integer(-10));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(120);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(100);
        pairs.put(second, new Integer(0));
        second = new Integer(107);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(99);
        pairs.put(second, new Integer(0));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(-18));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(113);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        second = new Integer(45);
        pairs.put(second, new Integer(-20));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(109);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-55));
        second = new Integer(110);
        pairs.put(second, new Integer(0));
        second = new Integer(115);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(108);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(146);
        pairs.put(second, new Integer(-92));
        second = new Integer(87);
        pairs.put(second, new Integer(-74));
        second = new Integer(89);
        pairs.put(second, new Integer(-100));
        second = new Integer(121);
        pairs.put(second, new Integer(-55));
        second = new Integer(84);
        pairs.put(second, new Integer(-92));
        second = new Integer(86);
        pairs.put(second, new Integer(-100));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-110));
        second = new Integer(45);
        pairs.put(second, new Integer(-111));
        second = new Integer(105);
        pairs.put(second, new Integer(-55));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(58);
        pairs.put(second, new Integer(-92));
        second = new Integer(97);
        pairs.put(second, new Integer(-100));
        second = new Integer(65);
        pairs.put(second, new Integer(-120));
        second = new Integer(117);
        pairs.put(second, new Integer(-111));
        second = new Integer(46);
        pairs.put(second, new Integer(-129));
        second = new Integer(101);
        pairs.put(second, new Integer(-100));
        second = new Integer(59);
        pairs.put(second, new Integer(-92));
        second = new Integer(44);
        pairs.put(second, new Integer(-129));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-70));
        second = new Integer(146);
        pairs.put(second, new Integer(-70));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

