/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.GlyfTable;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableName;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTFSubSetFile
extends TTFFile {
    private byte[] output = null;
    private int realSize = 0;
    private int currentPos = 0;
    private Map<TTFTableName, Integer> offsets = new HashMap<TTFTableName, Integer>();
    private int checkSumAdjustmentOffset = 0;
    private int locaOffset = 0;
    private int[] glyphOffsets;
    private Map<TTFTableName, TTFDirTabEntry> newDirTabs = new HashMap<TTFTableName, TTFDirTabEntry>();

    public TTFSubSetFile() {
    }

    public TTFSubSetFile(boolean useKerning, boolean useAdvanced) {
        super(useKerning, useAdvanced);
    }

    private int determineTableCount() {
        int numTables = 4;
        if (this.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF glyphs are not supported");
        }
        numTables += 5;
        if (this.hasCvt()) {
            ++numTables;
        }
        if (this.hasFpgm()) {
            ++numTables;
        }
        if (this.hasPrep()) {
            ++numTables;
        }
        return numTables;
    }

    private void createDirectory() {
        int numTables = this.determineTableCount();
        this.writeByte((byte)0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.realSize += 4;
        this.writeUShort(numTables);
        this.realSize += 2;
        int maxPow = this.maxPow2(numTables);
        int searchRange = (int)Math.pow(2.0, maxPow) * 16;
        this.writeUShort(searchRange);
        this.realSize += 2;
        this.writeUShort(maxPow);
        this.realSize += 2;
        this.writeUShort(numTables * 16 - searchRange);
        this.realSize += 2;
        this.writeTableName(TTFTableName.OS2);
        if (this.hasCvt()) {
            this.writeTableName(TTFTableName.CVT);
        }
        if (this.hasFpgm()) {
            this.writeTableName(TTFTableName.FPGM);
        }
        this.writeTableName(TTFTableName.GLYF);
        this.writeTableName(TTFTableName.HEAD);
        this.writeTableName(TTFTableName.HHEA);
        this.writeTableName(TTFTableName.HMTX);
        this.writeTableName(TTFTableName.LOCA);
        this.writeTableName(TTFTableName.MAXP);
        this.writeTableName(TTFTableName.NAME);
        this.writeTableName(TTFTableName.POST);
        if (this.hasPrep()) {
            this.writeTableName(TTFTableName.PREP);
        }
        this.newDirTabs.put(TTFTableName.TABLE_DIRECTORY, new TTFDirTabEntry(0L, this.currentPos));
    }

    private void writeTableName(TTFTableName tableName) {
        this.writeString(tableName.getName());
        this.offsets.put(tableName, this.currentPos);
        this.currentPos += 12;
        this.realSize += 16;
    }

    private boolean hasCvt() {
        return this.dirTabs.containsKey(TTFTableName.CVT);
    }

    private boolean hasFpgm() {
        return this.dirTabs.containsKey(TTFTableName.FPGM);
    }

    private boolean hasPrep() {
        return this.dirTabs.containsKey(TTFTableName.PREP);
    }

    private void createLoca(int size2) throws IOException {
        this.pad4();
        this.locaOffset = this.currentPos;
        int dirTableOffset = this.offsets.get(TTFTableName.LOCA);
        this.writeULong(dirTableOffset + 4, this.currentPos);
        this.writeULong(dirTableOffset + 8, size2 * 4 + 4);
        this.currentPos += size2 * 4 + 4;
        this.realSize += size2 * 4 + 4;
    }

    private boolean copyTable(FontFileReader in, TTFTableName tableName) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(tableName);
        if (entry != null) {
            this.pad4();
            this.seekTab(in, tableName, 0L);
            System.arraycopy(in.getBytes((int)entry.getOffset(), (int)entry.getLength()), 0, this.output, this.currentPos, (int)entry.getLength());
            this.updateCheckSum(this.currentPos, (int)entry.getLength(), tableName);
            this.currentPos += (int)entry.getLength();
            this.realSize += (int)entry.getLength();
            return true;
        }
        return false;
    }

    private boolean createCvt(FontFileReader in) throws IOException {
        return this.copyTable(in, TTFTableName.CVT);
    }

    private boolean createFpgm(FontFileReader in) throws IOException {
        return this.copyTable(in, TTFTableName.FPGM);
    }

    private boolean createName(FontFileReader in) throws IOException {
        return this.copyTable(in, TTFTableName.NAME);
    }

    private boolean createOS2(FontFileReader in) throws IOException {
        return this.copyTable(in, TTFTableName.OS2);
    }

    private void createMaxp(FontFileReader in, int size2) throws IOException {
        TTFTableName maxp = TTFTableName.MAXP;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(maxp);
        if (entry != null) {
            this.pad4();
            this.seekTab(in, maxp, 0L);
            System.arraycopy(in.getBytes((int)entry.getOffset(), (int)entry.getLength()), 0, this.output, this.currentPos, (int)entry.getLength());
            this.writeUShort(this.currentPos + 4, size2);
            this.updateCheckSum(this.currentPos, (int)entry.getLength(), maxp);
            this.currentPos += (int)entry.getLength();
            this.realSize += (int)entry.getLength();
        } else {
            throw new IOException("Can't find maxp table");
        }
    }

    private void createPost(FontFileReader in) throws IOException {
        TTFTableName post = TTFTableName.POST;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(post);
        if (entry != null) {
            this.pad4();
            this.seekTab(in, post, 0L);
            int newTableSize = 32;
            byte[] newPostTable = new byte[newTableSize];
            System.arraycopy(in.getBytes((int)entry.getOffset(), newTableSize), 0, newPostTable, 0, newTableSize);
            newPostTable[1] = 3;
            System.arraycopy(newPostTable, 0, this.output, this.currentPos, newTableSize);
            this.updateCheckSum(this.currentPos, newTableSize, post);
            this.currentPos += newTableSize;
            this.realSize += newTableSize;
        } else {
            throw new IOException("Can't find post table");
        }
    }

    private boolean createPrep(FontFileReader in) throws IOException {
        return this.copyTable(in, TTFTableName.PREP);
    }

    private void createHhea(FontFileReader in, int size2) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(TTFTableName.HHEA);
        if (entry != null) {
            this.pad4();
            this.seekTab(in, TTFTableName.HHEA, 0L);
            System.arraycopy(in.getBytes((int)entry.getOffset(), (int)entry.getLength()), 0, this.output, this.currentPos, (int)entry.getLength());
            this.writeUShort((int)entry.getLength() + this.currentPos - 2, size2);
            this.updateCheckSum(this.currentPos, (int)entry.getLength(), TTFTableName.HHEA);
            this.currentPos += (int)entry.getLength();
            this.realSize += (int)entry.getLength();
        } else {
            throw new IOException("Can't find hhea table");
        }
    }

    private void createHead(FontFileReader in) throws IOException {
        TTFTableName head2 = TTFTableName.HEAD;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(head2);
        if (entry != null) {
            this.pad4();
            this.seekTab(in, head2, 0L);
            System.arraycopy(in.getBytes((int)entry.getOffset(), (int)entry.getLength()), 0, this.output, this.currentPos, (int)entry.getLength());
            this.checkSumAdjustmentOffset = this.currentPos + 8;
            this.output[this.currentPos + 8] = 0;
            this.output[this.currentPos + 9] = 0;
            this.output[this.currentPos + 10] = 0;
            this.output[this.currentPos + 11] = 0;
            this.output[this.currentPos + 50] = 0;
            this.output[this.currentPos + 51] = 1;
            this.updateCheckSum(this.currentPos, (int)entry.getLength(), head2);
            this.currentPos += (int)entry.getLength();
            this.realSize += (int)entry.getLength();
        } else {
            throw new IOException("Can't find head table");
        }
    }

    private void createGlyf(FontFileReader in, Map<Integer, Integer> glyphs) throws IOException {
        TTFTableName glyf = TTFTableName.GLYF;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(glyf);
        int size2 = 0;
        int startPos = 0;
        int endOffset = 0;
        if (entry != null) {
            this.pad4();
            startPos = this.currentPos;
            int[] origIndexes = this.buildSubsetIndexToOrigIndexMap(glyphs);
            this.glyphOffsets = new int[origIndexes.length];
            for (int i = 0; i < origIndexes.length; ++i) {
                int nextOffset = 0;
                int origGlyphIndex = origIndexes[i];
                nextOffset = origGlyphIndex >= this.mtxTab.length - 1 ? (int)this.lastLoca : (int)this.mtxTab[origGlyphIndex + 1].getOffset();
                int glyphOffset = (int)this.mtxTab[origGlyphIndex].getOffset();
                int glyphLength = nextOffset - glyphOffset;
                byte[] glyphData = in.getBytes((int)entry.getOffset() + glyphOffset, glyphLength);
                int endOffset1 = endOffset;
                System.arraycopy(glyphData, 0, this.output, this.currentPos, glyphLength);
                this.writeULong(this.locaOffset + i * 4, this.currentPos - startPos);
                if (this.currentPos - startPos + glyphLength > endOffset1) {
                    endOffset1 = this.currentPos - startPos + glyphLength;
                }
                this.glyphOffsets[i] = this.currentPos;
                this.currentPos += glyphLength;
                this.realSize += glyphLength;
                endOffset = endOffset1;
            }
            size2 = this.currentPos - startPos;
            this.currentPos += 12;
            this.realSize += 12;
        } else {
            throw new IOException("Can't find glyf table");
        }
        this.updateCheckSum(startPos, size2 + 12, glyf);
        this.writeULong(this.locaOffset + glyphs.size() * 4, endOffset);
        int locaSize = glyphs.size() * 4 + 4;
        int checksum = TTFSubSetFile.getCheckSum(this.output, this.locaOffset, locaSize);
        this.writeULong(this.offsets.get(TTFTableName.LOCA), checksum);
        int padSize = (this.locaOffset + locaSize) % 4;
        this.newDirTabs.put(TTFTableName.LOCA, new TTFDirTabEntry(this.locaOffset, locaSize + padSize));
    }

    private int[] buildSubsetIndexToOrigIndexMap(Map<Integer, Integer> glyphs) {
        int[] origIndexes = new int[glyphs.size()];
        for (Map.Entry<Integer, Integer> glyph : glyphs.entrySet()) {
            int origIndex = glyph.getKey();
            int subsetIndex = glyph.getValue();
            origIndexes[subsetIndex] = origIndex;
        }
        return origIndexes;
    }

    private void createHmtx(FontFileReader in, Map<Integer, Integer> glyphs) throws IOException {
        TTFTableName hmtx = TTFTableName.HMTX;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get(hmtx);
        int longHorMetricSize = glyphs.size() * 2;
        int leftSideBearingSize = glyphs.size() * 2;
        int hmtxSize = longHorMetricSize + leftSideBearingSize;
        if (entry != null) {
            this.pad4();
            for (Map.Entry<Integer, Integer> glyph : glyphs.entrySet()) {
                Integer origIndex = glyph.getKey();
                Integer subsetIndex = glyph.getValue();
                this.writeUShort(this.currentPos + subsetIndex * 4, this.mtxTab[origIndex].getWx());
                this.writeUShort(this.currentPos + subsetIndex * 4 + 2, this.mtxTab[origIndex].getLsb());
            }
            this.updateCheckSum(this.currentPos, hmtxSize, hmtx);
            this.currentPos += hmtxSize;
            this.realSize += hmtxSize;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    @Override
    public void readFont(FontFileReader in, String name, Map<Integer, Integer> glyphs) throws IOException {
        this.fontFile = in;
        if (!this.checkTTC(name)) {
            throw new IOException("Failed to read font");
        }
        HashMap<Integer, Integer> subsetGlyphs = new HashMap<Integer, Integer>(glyphs);
        this.output = new byte[in.getFileSize()];
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.readIndexToLocation();
        this.scanGlyphs(in, subsetGlyphs);
        this.createDirectory();
        boolean optionalTableFound = this.createCvt(in);
        if (!optionalTableFound) {
            this.log.debug("TrueType: ctv table not present. Skipped.");
        }
        if (!(optionalTableFound = this.createFpgm(in))) {
            this.log.debug("TrueType: fpgm table not present. Skipped.");
        }
        this.createLoca(subsetGlyphs.size());
        this.createGlyf(in, subsetGlyphs);
        this.createOS2(in);
        this.createHead(in);
        this.createHhea(in, subsetGlyphs.size());
        this.createHmtx(in, subsetGlyphs);
        this.createMaxp(in, subsetGlyphs.size());
        this.createName(in);
        this.createPost(in);
        optionalTableFound = this.createPrep(in);
        if (!optionalTableFound) {
            this.log.debug("TrueType: prep table not present. Skipped.");
        }
        this.pad4();
        this.createCheckSumAdjustment();
    }

    public byte[] getFontSubset() {
        byte[] ret = new byte[this.realSize];
        System.arraycopy(this.output, 0, ret, 0, this.realSize);
        return ret;
    }

    private void handleGlyphSubset(TTFGlyphOutputStream glyphOut) throws IOException {
        glyphOut.startGlyphStream();
        for (int i = 0; i < this.glyphOffsets.length - 1; ++i) {
            glyphOut.streamGlyph(this.output, this.glyphOffsets[i], this.glyphOffsets[i + 1] - this.glyphOffsets[i]);
        }
        TTFDirTabEntry glyf = this.newDirTabs.get(TTFTableName.GLYF);
        long lastGlyphLength = glyf.getLength() - ((long)this.glyphOffsets[this.glyphOffsets.length - 1] - glyf.getOffset());
        glyphOut.streamGlyph(this.output, this.glyphOffsets[this.glyphOffsets.length - 1], (int)lastGlyphLength);
        glyphOut.endGlyphStream();
    }

    @Override
    public void stream(TTFOutputStream ttfOut) throws IOException {
        SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortedDirTabs = this.sortDirTabMap(this.newDirTabs);
        TTFTableOutputStream tableOut = ttfOut.getTableOutputStream();
        TTFGlyphOutputStream glyphOut = ttfOut.getGlyphOutputStream();
        ttfOut.startFontStream();
        for (Map.Entry entry : sortedDirTabs) {
            if (((TTFTableName)entry.getKey()).equals(TTFTableName.GLYF)) {
                this.handleGlyphSubset(glyphOut);
                continue;
            }
            tableOut.streamTable(this.output, (int)((TTFDirTabEntry)entry.getValue()).getOffset(), (int)((TTFDirTabEntry)entry.getValue()).getLength());
        }
        ttfOut.endFontStream();
    }

    private void scanGlyphs(FontFileReader in, Map<Integer, Integer> subsetGlyphs) throws IOException {
        TTFDirTabEntry glyfTableInfo = (TTFDirTabEntry)this.dirTabs.get(TTFTableName.GLYF);
        if (glyfTableInfo == null) {
            throw new IOException("Glyf table could not be found");
        }
        GlyfTable glyfTable = new GlyfTable(in, this.mtxTab, glyfTableInfo, subsetGlyphs);
        glyfTable.populateGlyphsWithComposites();
    }

    private int writeString(String str) {
        int length = 0;
        try {
            byte[] buf = str.getBytes("ISO-8859-1");
            System.arraycopy(buf, 0, this.output, this.currentPos, buf.length);
            length = buf.length;
            this.currentPos += length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return length;
    }

    private void writeByte(byte b) {
        this.output[this.currentPos++] = b;
    }

    private void writeUShort(int s2) {
        byte b1 = (byte)(s2 >> 8 & 0xFF);
        byte b2 = (byte)(s2 & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
    }

    private void writeUShort(int pos, int s2) {
        byte b1 = (byte)(s2 >> 8 & 0xFF);
        byte b2 = (byte)(s2 & 0xFF);
        this.output[pos] = b1;
        this.output[pos + 1] = b2;
    }

    private void writeULong(int pos, int s2) {
        byte b1 = (byte)(s2 >> 24 & 0xFF);
        byte b2 = (byte)(s2 >> 16 & 0xFF);
        byte b3 = (byte)(s2 >> 8 & 0xFF);
        byte b4 = (byte)(s2 & 0xFF);
        this.output[pos] = b1;
        this.output[pos + 1] = b2;
        this.output[pos + 2] = b3;
        this.output[pos + 3] = b4;
    }

    private void pad4() {
        int padSize = this.getPadSize(this.currentPos);
        if (padSize < 4) {
            for (int i = 0; i < padSize; ++i) {
                this.output[this.currentPos++] = 0;
                ++this.realSize;
            }
        }
    }

    private int maxPow2(int max2) {
        int i = 0;
        while (Math.pow(2.0, i) <= (double)max2) {
            ++i;
        }
        return i - 1;
    }

    private void updateCheckSum(int tableStart, int tableSize, TTFTableName tableName) {
        int checksum = TTFSubSetFile.getCheckSum(this.output, tableStart, tableSize);
        int offset = this.offsets.get(tableName);
        int padSize = this.getPadSize(tableStart + tableSize);
        this.newDirTabs.put(tableName, new TTFDirTabEntry(tableStart, tableSize + padSize));
        this.writeULong(offset, checksum);
        this.writeULong(offset + 4, tableStart);
        this.writeULong(offset + 8, tableSize);
    }

    private static int getCheckSum(byte[] data2, int start, int size2) {
        int remainder = size2 % 4;
        if (remainder != 0) {
            size2 += remainder;
        }
        long sum2 = 0L;
        for (int i = 0; i < size2; i += 4) {
            long l = 0L;
            for (int j = 0; j < 4; ++j) {
                l <<= 8;
                l |= (long)(data2[start + i + j] & 0xFF);
            }
            sum2 += l;
        }
        return (int)sum2;
    }

    private void createCheckSumAdjustment() {
        long sum2 = TTFSubSetFile.getCheckSum(this.output, 0, this.realSize);
        int checksum = (int)(-1313820742L - sum2);
        this.writeULong(this.checkSumAdjustmentOffset, checksum);
    }
}

