/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

public class PDFDictionary
extends PDFObject {
    protected Map<String, Object> entries = new HashMap<String, Object>();
    protected List<String> order = new ArrayList<String>();

    public PDFDictionary() {
    }

    public PDFDictionary(PDFObject parent) {
        super(parent);
    }

    public void put(String name, Object value2) {
        PDFObject pdfObj;
        if (value2 instanceof PDFObject && !(pdfObj = (PDFObject)value2).hasObjectNumber()) {
            pdfObj.setParent(this);
        }
        if (!this.entries.containsKey(name)) {
            this.order.add(name);
        }
        this.entries.put(name, value2);
    }

    public void put(String name, int value2) {
        if (!this.entries.containsKey(name)) {
            this.order.add(name);
        }
        this.entries.put(name, value2);
    }

    public Object get(String name) {
        return this.entries.get(name);
    }

    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        this.writeDictionary(cout, textBuffer);
        PDFDocument.flushTextBuffer(textBuffer, cout);
        return cout.getCount();
    }

    protected void writeDictionary(OutputStream out, StringBuilder textBuffer) throws IOException {
        textBuffer.append("<<");
        boolean compact = this.order.size() <= 2;
        for (String key : this.order) {
            if (compact) {
                textBuffer.append(' ');
            } else {
                textBuffer.append("\n  ");
            }
            textBuffer.append(PDFName.escapeName(key));
            textBuffer.append(' ');
            Object obj = this.entries.get(key);
            this.formatObject(obj, out, textBuffer);
        }
        if (compact) {
            textBuffer.append(' ');
        } else {
            textBuffer.append('\n');
        }
        textBuffer.append(">>\n");
    }
}

