/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.util.LinkedList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;

public class RtfSpaceManager {
    private LinkedList blockAttributes = new LinkedList();
    private LinkedList inlineAttributes = new LinkedList();
    private int accumulatedSpace = 0;

    public void stopUpdatingSpaceBefore() {
        for (RtfSpaceSplitter splitter2 : this.blockAttributes) {
            if (!splitter2.isBeforeCadidateSet()) continue;
            splitter2.stopUpdatingSpaceBefore();
        }
    }

    public void setCandidate(RtfAttributes attrs) {
        for (RtfSpaceSplitter splitter2 : this.blockAttributes) {
            splitter2.setSpaceBeforeCandidate(attrs);
            splitter2.setSpaceAfterCandidate(attrs);
        }
    }

    public RtfSpaceSplitter pushRtfSpaceSplitter(RtfAttributes attrs) {
        RtfSpaceSplitter splitter2 = new RtfSpaceSplitter(attrs, this.accumulatedSpace);
        this.accumulatedSpace = 0;
        this.blockAttributes.addLast(splitter2);
        return splitter2;
    }

    public void popRtfSpaceSplitter() {
        if (!this.blockAttributes.isEmpty()) {
            RtfSpaceSplitter splitter2 = (RtfSpaceSplitter)this.blockAttributes.removeLast();
            this.accumulatedSpace += splitter2.flush();
        }
    }

    public void pushInlineAttributes(RtfAttributes attrs) {
        this.inlineAttributes.addLast(attrs);
    }

    public void popInlineAttributes() {
        if (!this.inlineAttributes.isEmpty()) {
            this.inlineAttributes.removeLast();
        }
    }

    public RtfAttributes getLastInlineAttribute() {
        return (RtfAttributes)this.inlineAttributes.getLast();
    }
}

