/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.ToStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_tracer != null) {
            super.fireStartElem(name);
            this.firePseudoAttributes();
        }
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushPending();
        try {
            this.writeNormalizedChars(ch, start, length, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCharEvent(ch, start, length);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false, this.m_lineSepUse);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData, boolean useLineSep) throws IOException, SAXException {
        Writer writer = this.m_writer;
        int end = start + length;
        int S_LINEFEED = 10;
        int M_MAXCHARACTER = this.m_maxCharacter;
        if (isCData) {
            int i = start;
            while (i < end) {
                char c = ch[i];
                if ('\n' == c && useLineSep) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else if (c > M_MAXCHARACTER) {
                    if (i != 0) {
                        this.closeCDATA();
                    }
                    if (ToStream.isUTF16Surrogate(c)) {
                        this.writeUTF16Surrogate(c, ch, i, end);
                        ++i;
                    } else {
                        writer.write(c);
                    }
                    if (i != 0 && i < end - 1) {
                        writer.write("<![CDATA[");
                        this.m_cdataTagOpen = true;
                    }
                } else if (i < end - 2 && ']' == c && ']' == ch[i + 1] && '>' == ch[i + 2]) {
                    writer.write("]]]]><![CDATA[>");
                    i += 2;
                } else if (c <= M_MAXCHARACTER) {
                    writer.write(c);
                } else if (ToStream.isUTF16Surrogate(c)) {
                    this.writeUTF16Surrogate(c, ch, i, end);
                    ++i;
                } else {
                    String encoding = this.getEncoding();
                    if (encoding != null) {
                        String integralValue = Integer.toString(c);
                        throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{integralValue, encoding}));
                    }
                    writer.write(c);
                }
                ++i;
            }
        } else {
            int i = start;
            while (i < end) {
                char c = ch[i];
                if ('\n' == c && useLineSep) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else if (c <= M_MAXCHARACTER) {
                    writer.write(c);
                } else if (ToStream.isUTF16Surrogate(c)) {
                    this.writeUTF16Surrogate(c, ch, i, end);
                    ++i;
                } else {
                    String encoding = this.getEncoding();
                    if (encoding != null) {
                        String integralValue = Integer.toString(c);
                        throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{integralValue, encoding}));
                    }
                    writer.write(c);
                }
                ++i;
            }
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(ch, start, length);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false, this.m_lineSepUse);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void processingInstruction(String target, String data2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(target, data2);
        }
    }

    public void comment(String data2) throws SAXException {
        int length = data2.length();
        if (length > this.m_charsBuff.length) {
            this.m_charsBuff = new char[length * 2 + 1];
        }
        data2.getChars(0, length, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(ch, start, length);
        }
    }

    public void entityReference(String name) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(name);
        }
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value2) {
    }

    public void endCDATA() throws SAXException {
    }

    public void endElement(String elemName) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(elemName);
        }
    }

    public void startElement(String elementNamespaceURI, String elementLocalName, String elementName) throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(elementName);
            this.firePseudoAttributes();
        }
    }

    public void characters(String characters2) throws SAXException {
        int length = characters2.length();
        if (length > this.m_charsBuff.length) {
            this.m_charsBuff = new char[length * 2 + 1];
        }
        characters2.getChars(0, length, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, length);
    }

    public void addAttribute(String name, String value2) {
    }

    public void addUniqueAttribute(String qName, String value2, int flags) throws SAXException {
    }

    public boolean startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        return false;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void namespaceAfterStartElement(String prefix, String uri) throws SAXException {
    }

    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }
}

