/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.ObjectFactory;
import org.apache.xml.utils.WrappedRuntimeException;

public class ObjectPool
implements Serializable {
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class type) {
        this.objectType = type;
        this.freeStack = new Vector();
    }

    public ObjectPool(String className) {
        try {
            this.objectType = ObjectFactory.findProviderClass(className, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException cnfe) {
            throw new WrappedRuntimeException(cnfe);
        }
        this.freeStack = new Vector();
    }

    public ObjectPool(Class type, int size2) {
        this.objectType = type;
        this.freeStack = new Vector(size2);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object result2 = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return result2;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object result2 = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return result2;
    }

    public synchronized void freeInstance(Object obj) {
        this.freeStack.addElement(obj);
    }
}

