/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl.imageio;

import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.imageio.ImageIOUtil;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderImageIO
extends AbstractImagePreloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException, ImageException {
        if (!ImageUtil.hasImageInputStream(src)) {
            return null;
        }
        ImageInputStream in = ImageUtil.needImageInputStream(src);
        Iterator<ImageReader> iter2 = ImageIO.getImageReaders(in);
        if (!iter2.hasNext()) {
            return null;
        }
        Throwable firstIOException = null;
        IIOMetadata iiometa = null;
        ImageSize size2 = null;
        String mime = null;
        while (iter2.hasNext()) {
            in.mark();
            ImageReader reader = iter2.next();
            try {
                reader.setInput(ImageUtil.ignoreFlushing(in), true, false);
                boolean imageIndex = false;
                iiometa = reader.getImageMetadata(0);
                size2 = new ImageSize();
                size2.setSizeInPixels(reader.getWidth(0), reader.getHeight(0));
                mime = reader.getOriginatingProvider().getMIMETypes()[0];
                break;
            }
            catch (IOException ioe) {
                if (firstIOException != null) continue;
                firstIOException = ioe;
            }
            finally {
                reader.dispose();
                in.reset();
            }
        }
        if (iiometa == null) {
            if (firstIOException == null) {
                throw new ImageException("Could not extract image metadata");
            }
            throw new ImageException("I/O error while extracting image metadata" + (firstIOException.getMessage() != null ? ": " + firstIOException.getMessage() : ""), firstIOException);
        }
        size2.setResolution(context.getSourceResolution());
        ImageIOUtil.extractResolution(iiometa, size2);
        if (size2.getWidthPx() <= 0 || size2.getHeightPx() <= 0) {
            return null;
        }
        if (size2.getWidthMpt() == 0) {
            size2.calcSizeFromPixels();
        }
        ImageInfo info = new ImageInfo(uri, mime);
        info.getCustomObjects().put(ImageIOUtil.IMAGEIO_METADATA, iiometa);
        info.setSize(size2);
        return info;
    }

    public int getPriority() {
        return 2000;
    }
}

