/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.util.Service;

public class ImageWriterRegistry {
    private static ImageWriterRegistry instance;
    private Map imageWriterMap = new HashMap();
    private Map preferredOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageWriterRegistry() {
        Properties props = new Properties();
        InputStream in = this.getClass().getResourceAsStream("default-preferred-order.properties");
        if (in != null) {
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load default preferred order due to I/O error: " + ioe.getMessage());
            }
        }
        this.preferredOrder = props;
        this.setup();
    }

    public ImageWriterRegistry(Properties preferredOrder) {
        this.preferredOrder = preferredOrder;
        this.setup();
    }

    public static ImageWriterRegistry getInstance() {
        if (instance == null) {
            instance = new ImageWriterRegistry();
        }
        return instance;
    }

    private void setup() {
        Iterator<Object> iter2 = Service.providers(ImageWriter.class);
        while (iter2.hasNext()) {
            ImageWriter writer = (ImageWriter)iter2.next();
            this.register(writer);
        }
    }

    private int getPriority(ImageWriter writer) {
        int pos;
        String key = writer.getClass().getName();
        Object value2 = this.preferredOrder.get(key);
        while (value2 == null && (pos = key.lastIndexOf(".")) >= 0) {
            key = key.substring(0, pos);
            value2 = this.preferredOrder.get(key);
        }
        return value2 != null ? Integer.parseInt(value2.toString()) : 0;
    }

    public void register(ImageWriter writer, int priority) {
        String key = writer.getClass().getName();
        this.preferredOrder.put(key, String.valueOf(priority));
        this.register(writer);
    }

    public void register(ImageWriter writer) {
        ArrayList entries = (ArrayList)this.imageWriterMap.get(writer.getMIMEType());
        if (entries == null) {
            entries = new ArrayList();
            this.imageWriterMap.put(writer.getMIMEType(), entries);
        }
        int priority = this.getPriority(writer);
        ListIterator<ImageWriter> li = entries.listIterator();
        while (li.hasNext()) {
            ImageWriter w = (ImageWriter)li.next();
            if (this.getPriority(w) >= priority) continue;
            li.previous();
            break;
        }
        li.add(writer);
    }

    public ImageWriter getWriterFor(String mime) {
        List entries = (List)this.imageWriterMap.get(mime);
        if (entries == null) {
            return null;
        }
        for (ImageWriter writer : entries) {
            if (!writer.isFunctional()) continue;
            return writer;
        }
        return null;
    }
}

