/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.relationship;

import java.util.HashSet;
import java.util.Set;
import org.gedcom4j.model.FamilyChild;
import org.gedcom4j.model.FamilySpouse;
import org.gedcom4j.model.Individual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AncestryCalculator {
    private boolean addedAnyCommonAncestors;
    private Set<Individual> checkedAlready;
    private Set<Individual> targetList;

    public Set<Individual> getExtendedAncestry(Individual individual) {
        HashSet<Individual> result2 = new HashSet<Individual>();
        for (FamilyChild fc : individual.familiesWhereChild) {
            Individual mom;
            Individual dad = fc.family.husband;
            if (dad != null && !result2.contains(dad)) {
                result2.add(dad);
                for (FamilySpouse fs : dad.familiesWhereSpouse) {
                    Individual dadsWife = fs.family.wife;
                    if (dadsWife == null) continue;
                    result2.add(dadsWife);
                    result2.addAll(this.getExtendedAncestry(dadsWife));
                }
                result2.addAll(this.getExtendedAncestry(dad));
            }
            if ((mom = fc.family.wife) == null || result2.contains(mom)) continue;
            result2.add(mom);
            for (FamilySpouse fs : mom.familiesWhereSpouse) {
                Individual momsHusband = fs.family.husband;
                if (momsHusband == null) continue;
                result2.add(momsHusband);
                result2.addAll(this.getExtendedAncestry(momsHusband));
            }
            result2.addAll(this.getExtendedAncestry(mom));
        }
        return result2;
    }

    public Set<Individual> getLowestCommonAncestors(Individual individual1, Individual individual2) {
        HashSet<Individual> result2 = new HashSet<Individual>();
        this.initializeLcaSearch(individual1);
        this.addLowestCommonAncestorsToSet(individual2, result2, 0);
        return result2;
    }

    void addLowestCommonAncestorsToSet(Individual individual, Set<Individual> set, int level) {
        if (individual == null) {
            return;
        }
        if (this.checkedAlready.contains(individual)) {
            return;
        }
        this.checkedAlready.add(individual);
        for (FamilyChild fc : individual.familiesWhereChild) {
            if (!this.checkedAlready.contains(fc.family.husband)) {
                this.checkParent(level, set, fc.family.husband, individual, true);
            }
            if (this.checkedAlready.contains(fc.family.wife)) continue;
            this.checkParent(level, set, fc.family.wife, individual, false);
        }
        if (!this.addedAnyCommonAncestors) {
            for (FamilyChild fc : individual.familiesWhereChild) {
                Individual mom;
                Individual dad = fc.family.husband;
                if (dad != null && !this.checkedAlready.contains(dad)) {
                    this.addLowestCommonAncestorsToSet(dad, set, level + 1);
                }
                if ((mom = fc.family.wife) == null || this.checkedAlready.contains(mom)) continue;
                this.addLowestCommonAncestorsToSet(mom, set, level + 1);
            }
        }
    }

    void checkParent(int level, Set<Individual> set, Individual parent, Individual child, boolean parentIsDad) {
        if (parent == null) {
            return;
        }
        if (this.targetList.contains(parent)) {
            set.add(parent);
            this.addedAnyCommonAncestors = true;
            return;
        }
        for (FamilySpouse fs : parent.familiesWhereSpouse) {
            Individual spouse2 = this.getSpouse(fs, parent);
            if (spouse2 == null) continue;
            if (this.targetList.contains(spouse2)) {
                set.add(spouse2);
                this.addedAnyCommonAncestors = true;
                continue;
            }
            if (this.checkedAlready.contains(spouse2) || spouse2.familiesWhereChild.isEmpty()) continue;
            HashSet<Individual> s2 = new HashSet<Individual>();
            this.addLowestCommonAncestorsToSet(spouse2, s2, level + 1);
            if (s2.isEmpty()) continue;
            set.addAll(s2);
            this.addedAnyCommonAncestors = true;
        }
    }

    Individual getSpouse(FamilySpouse fs, Individual i) {
        if (fs.family.husband == i) {
            return fs.family.wife;
        }
        if (fs.family.wife == i) {
            return fs.family.husband;
        }
        return null;
    }

    void initializeLcaSearch(Individual individual1) {
        this.targetList = this.getExtendedAncestry(individual1);
        this.checkedAlready = new HashSet<Individual>();
        this.addedAnyCommonAncestors = false;
    }
}

