/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.relationship;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gedcom4j.model.FamilyChild;
import org.gedcom4j.model.FamilySpouse;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.relationship.Relationship;
import org.gedcom4j.relationship.RelationshipName;
import org.gedcom4j.relationship.SimpleRelationship;
import org.gedcom4j.relationship.SimplificationRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipCalculator {
    private Individual startingIndividual;
    private Individual targetIndividual;
    public List<Relationship> relationshipsFound;
    private List<SimpleRelationship> currentChain;
    private Set<Individual> lookedAt = new HashSet<Individual>();

    private void collapse(List<SimpleRelationship> chain2, RelationshipName rel1, RelationshipName rel2, RelationshipName newRel) {
        for (int i = 0; i < chain2.size() - 1; ++i) {
            RelationshipName rr;
            SimpleRelationship s1 = chain2.get(i);
            SimpleRelationship s2 = chain2.get(i + 1);
            if (s1.name != rel1 || s2.name != rel2 || s1.individual2 != s2.individual1 || (rr = this.getReverseRelationship(newRel, s1.individual1.sex)) == null) continue;
            s1.individual2 = s2.individual2;
            s1.name = newRel;
            s1.reverseName = rr;
            chain2.remove(i + 1);
        }
    }

    private void examine(Individual personBeingExamined) {
        if (personBeingExamined == null) {
            return;
        }
        if (this.lookedAt.contains(personBeingExamined)) {
            return;
        }
        if (personBeingExamined == this.targetIndividual) {
            Relationship r = new Relationship(this.startingIndividual, this.targetIndividual, this.currentChain);
            this.relationshipsFound.add(r);
        } else {
            this.lookedAt.add(personBeingExamined);
            for (FamilySpouse fs : personBeingExamined.familiesWhereSpouse) {
                if (fs.family.husband == personBeingExamined) {
                    if (this.lookedAt.contains(fs.family.wife)) continue;
                    this.examineWife(personBeingExamined, fs);
                } else if (fs.family.wife == personBeingExamined) {
                    if (this.lookedAt.contains(fs.family.husband)) continue;
                    this.examineHusband(personBeingExamined, fs);
                }
                for (Individual c : fs.family.children) {
                    if (this.lookedAt.contains(c)) continue;
                    if (fs.family.husband == personBeingExamined) {
                        this.examineChild(personBeingExamined, c, RelationshipName.FATHER);
                        continue;
                    }
                    if (fs.family.wife != personBeingExamined) continue;
                    this.examineChild(personBeingExamined, c, RelationshipName.MOTHER);
                }
            }
            for (FamilyChild fc : personBeingExamined.familiesWhereChild) {
                if (!this.lookedAt.contains(fc.family.husband)) {
                    this.examineFather(personBeingExamined, fc.family.husband);
                }
                if (this.lookedAt.contains(fc.family.wife)) continue;
                this.examineMother(personBeingExamined, fc.family.wife);
            }
        }
    }

    private void examineChild(Individual personBeingExamined, Individual child, RelationshipName reverseRelationship) {
        SimpleRelationship r = new SimpleRelationship();
        r.individual1 = personBeingExamined;
        r.individual2 = child;
        r.name = "M".equals(child.sex.value) ? RelationshipName.SON : ("F".equals(child.sex.value) ? RelationshipName.DAUGHTER : RelationshipName.CHILD);
        r.reverseName = reverseRelationship;
        this.currentChain.add(r);
        this.examine(r.individual2);
        this.currentChain.remove(this.currentChain.size() - 1);
    }

    private void examineFather(Individual personBeingExamined, Individual father2) {
        SimpleRelationship r = new SimpleRelationship();
        r.individual1 = personBeingExamined;
        r.individual2 = father2;
        r.reverseName = "M".equals(personBeingExamined.sex.value) ? RelationshipName.SON : ("F".equals(personBeingExamined.sex.value) ? RelationshipName.DAUGHTER : RelationshipName.CHILD);
        r.name = RelationshipName.FATHER;
        this.currentChain.add(r);
        this.examine(r.individual2);
        this.currentChain.remove(this.currentChain.size() - 1);
    }

    private void examineHusband(Individual personBeingExamined, FamilySpouse fs) {
        SimpleRelationship r = new SimpleRelationship();
        r.individual1 = personBeingExamined;
        r.individual2 = fs.family.husband;
        r.name = RelationshipName.HUSBAND;
        this.currentChain.add(r);
        this.examine(r.individual2);
        this.currentChain.remove(this.currentChain.size() - 1);
    }

    private void examineMother(Individual personBeingExamined, Individual mother2) {
        SimpleRelationship r = new SimpleRelationship();
        r.individual1 = personBeingExamined;
        r.individual2 = mother2;
        r.reverseName = "M".equals(personBeingExamined.sex.value) ? RelationshipName.SON : ("F".equals(personBeingExamined.sex.value) ? RelationshipName.DAUGHTER : RelationshipName.CHILD);
        r.name = RelationshipName.MOTHER;
        this.currentChain.add(r);
        this.examine(r.individual2);
        this.currentChain.remove(this.currentChain.size() - 1);
    }

    private void examineWife(Individual personBeingExamined, FamilySpouse fs) {
        SimpleRelationship r = new SimpleRelationship();
        r.individual1 = personBeingExamined;
        r.individual2 = fs.family.wife;
        r.name = RelationshipName.WIFE;
        this.currentChain.add(r);
        this.examine(r.individual2);
        this.currentChain.remove(this.currentChain.size() - 1);
    }

    private RelationshipName getReverseRelationship(RelationshipName relationship, StringWithCustomTags sex) {
        if ("M".equals(sex.value)) {
            return relationship.reverseForMale;
        }
        if ("F".equals(sex.value)) {
            return relationship.reverseForFemale;
        }
        return relationship.reverseForUnknown;
    }

    private void simplifyRelationship(Relationship relationship) {
        int previousLength = Integer.MAX_VALUE;
        while (relationship.chain.size() > 1) {
            if (relationship.chain.size() >= previousLength) {
                return;
            }
            previousLength = relationship.chain.size();
            for (RelationshipName[] rule : SimplificationRules.rules) {
                this.collapse(relationship.chain, rule[0], rule[1], rule[2]);
            }
        }
    }

    public void calculateRelationships(Individual individual1, Individual individual2, boolean simplified) {
        this.relationshipsFound = new ArrayList<Relationship>();
        this.startingIndividual = individual1;
        this.targetIndividual = individual2;
        this.currentChain = new ArrayList<SimpleRelationship>();
        this.lookedAt = new HashSet<Individual>();
        if (individual1 != individual2) {
            this.examine(individual1);
        }
        if (simplified) {
            for (Relationship r : this.relationshipsFound) {
                this.simplifyRelationship(r);
            }
        }
        if (this.relationshipsFound.size() > 1) {
            this.relationshipsFound = new ArrayList<Relationship>(new HashSet<Relationship>(this.relationshipsFound));
            Collections.sort(this.relationshipsFound);
            int shortestLength = this.relationshipsFound.get((int)0).chain.size();
            for (int i = this.relationshipsFound.size() - 1; i >= 0; --i) {
                if (this.relationshipsFound.get((int)i).chain.size() <= shortestLength) continue;
                this.relationshipsFound.remove(i);
            }
            int simplestSimplicity = Integer.MAX_VALUE;
            ArrayList<Relationship> keepers = new ArrayList<Relationship>();
            for (int i = this.relationshipsFound.size() - 1; i >= 0; --i) {
                Relationship r = this.relationshipsFound.get(i);
                int totalSimplicity = r.getTotalSimplicity();
                if (totalSimplicity == simplestSimplicity) {
                    keepers.add(r);
                    continue;
                }
                if (totalSimplicity >= simplestSimplicity) continue;
                keepers.clear();
                simplestSimplicity = totalSimplicity;
                keepers.add(r);
            }
            this.relationshipsFound = keepers;
        }
    }
}

