/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gedcom4j.model.Family;
import org.gedcom4j.model.Gedcom;
import org.gedcom4j.model.Header;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.Repository;
import org.gedcom4j.model.Source;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submission;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.model.Trailer;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.FamilyValidator;
import org.gedcom4j.validate.GedcomValidationFinding;
import org.gedcom4j.validate.HeaderValidator;
import org.gedcom4j.validate.IndividualValidator;
import org.gedcom4j.validate.MultimediaValidator;
import org.gedcom4j.validate.NoteValidator;
import org.gedcom4j.validate.RepositoryValidator;
import org.gedcom4j.validate.SourceValidator;
import org.gedcom4j.validate.SubmitterValidator;

public class GedcomValidator
extends AbstractValidator {
    public boolean autorepair = true;
    public List<GedcomValidationFinding> findings = new ArrayList<GedcomValidationFinding>();
    protected Gedcom gedcom = null;

    public GedcomValidator(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.rootValidator = this;
    }

    public void validate() {
        this.findings.clear();
        if (this.gedcom == null) {
            this.addError("gedcom structure is null");
            return;
        }
        this.validateSubmitters();
        this.validateHeader();
        this.validateIndividuals();
        this.validateFamilies();
        this.validateRepositories();
        this.validateMultimedia();
        this.validateNotes();
        this.validateSources();
        this.validateSubmission(this.gedcom.submission);
        this.validateTrailer();
        this.checkNotes(new ArrayList<Note>(this.gedcom.notes.values()), this.gedcom);
    }

    void validateSubmission(Submission s2) {
        if (s2 == null) {
            this.addError("Submission record on root gedcom is null", this.gedcom);
            return;
        }
        this.checkXref(s2);
        this.checkOptionalString(s2.ancestorsCount, "Ancestor count", (Object)s2);
        this.checkOptionalString(s2.descendantsCount, "Descendant count", (Object)s2);
        this.checkOptionalString(s2.nameOfFamilyFile, "Name of family file", (Object)s2);
        this.checkOptionalString(s2.ordinanceProcessFlag, "Ordinance process flag", (Object)s2);
        this.checkOptionalString(s2.recIdNumber, "Automated record id", (Object)s2);
        this.checkOptionalString(s2.templeCode, "Temple code", (Object)s2);
    }

    private void validateFamilies() {
        if (this.gedcom.families == null) {
            if (this.rootValidator.autorepair) {
                this.gedcom.families = new HashMap<String, Family>();
                this.rootValidator.addInfo("Map of families in gedcom was null - repaired", this.gedcom);
            } else {
                this.rootValidator.addError("Map of families in gedcom is null", this.gedcom);
                return;
            }
        }
        for (Map.Entry<String, Family> e : this.gedcom.families.entrySet()) {
            if (e.getKey() == null) {
                if (this.rootValidator.autorepair) {
                    this.rootValidator.addError("Family in map but has null key - cannot repair", e.getValue());
                    continue;
                }
                this.rootValidator.addError("Family in map but has null key", e.getValue());
                continue;
            }
            Family f = e.getValue();
            if (!e.getKey().equals(f.xref)) {
                if (this.rootValidator.autorepair) {
                    this.rootValidator.addError("Family in map not keyed by its xref - cannot repair", f.xref);
                    continue;
                }
                this.rootValidator.addError("Family in map not keyed by its xref", f.xref);
                continue;
            }
            new FamilyValidator(this, f).validate();
        }
    }

    private void validateHeader() {
        if (this.gedcom.header == null) {
            if (this.autorepair) {
                this.gedcom.header = new Header();
                this.addInfo("Header was null - autorepaired");
            } else {
                this.addError("GEDCOM Header is null");
                return;
            }
        }
        new HeaderValidator(this.rootValidator, this.gedcom.header).validate();
    }

    private void validateIndividuals() {
        if (this.gedcom.individuals == null) {
            if (this.autorepair) {
                this.gedcom.individuals = new HashMap<String, Individual>();
                this.addInfo("Individuals collection was null - autorepaired", this.gedcom);
            } else {
                this.addError("Individuals collection is null", this.gedcom);
                return;
            }
        }
        for (Map.Entry<String, Individual> e : this.gedcom.individuals.entrySet()) {
            if (e.getKey() == null) {
                this.addError("Entry in individuals collection has null key", e);
                return;
            }
            if (e.getValue() == null) {
                this.addError("Entry in individuals collection has null value", e);
                return;
            }
            if (!e.getKey().equals(e.getValue().xref)) {
                this.addError("Entry in individuals collection is not keyed by the individual's xref", e);
                return;
            }
            new IndividualValidator(this.rootValidator, e.getValue()).validate();
        }
    }

    private void validateMultimedia() {
        for (Multimedia m : this.gedcom.multimedia.values()) {
            MultimediaValidator mv = new MultimediaValidator(this, m);
            mv.validate();
        }
    }

    private void validateNotes() {
        int i = 0;
        for (Note n : this.gedcom.notes.values()) {
            new NoteValidator(this.rootValidator, ++i, n).validate();
        }
    }

    private void validateRepositories() {
        if (this.gedcom.repositories == null) {
            if (this.autorepair) {
                this.gedcom.repositories = new HashMap<String, Repository>();
                this.addInfo("Repositories collection on root gedcom was null - autorepaired", this.gedcom);
                return;
            }
            this.addError("Repositories collection on root gedcom is null", this.gedcom);
            return;
        }
        for (Map.Entry<String, Repository> e : this.gedcom.repositories.entrySet()) {
            if (e.getKey() == null) {
                this.addError("Entry in repositories collection has null key", e);
                return;
            }
            if (e.getValue() == null) {
                this.addError("Entry in repositories collection has null value", e);
                return;
            }
            if (!e.getKey().equals(e.getValue().xref)) {
                this.addError("Entry in repositories collection is not keyed by the Repository's xref", e);
                return;
            }
            new RepositoryValidator(this.rootValidator, e.getValue()).validate();
        }
    }

    private void validateSources() {
        if (this.gedcom.sources == null) {
            if (this.autorepair) {
                this.gedcom.sources = new HashMap<String, Source>();
                this.addInfo("Sources collection was null - autorepaired", this.gedcom);
            } else {
                this.addError("Sources collection is null", this.gedcom);
                return;
            }
        }
        for (Map.Entry<String, Source> e : this.gedcom.sources.entrySet()) {
            if (e.getKey() == null) {
                this.addError("Entry in sources collection has null key", e);
                return;
            }
            if (e.getValue() == null) {
                this.addError("Entry in sources collection has null value", e);
                return;
            }
            if (!e.getKey().equals(e.getValue().xref)) {
                this.addError("Entry in sources collection is not keyed by the individual's xref", e);
                return;
            }
            new SourceValidator(this.rootValidator, e.getValue()).validate();
        }
    }

    private void validateSubmitters() {
        if (this.gedcom.submitters == null) {
            if (this.autorepair) {
                this.gedcom.submitters = new HashMap<String, Submitter>();
                this.addInfo("Submitters collection was missing on gedcom - repaired", this.gedcom);
            } else {
                this.addInfo("Submitters collection is missing on gedcom", this.gedcom);
                return;
            }
        }
        if (this.gedcom.submitters.isEmpty()) {
            if (this.autorepair) {
                Submitter s2 = new Submitter();
                s2.xref = "@SUBM0000@";
                s2.name = new StringWithCustomTags("UNSPECIFIED");
                this.gedcom.submitters.put(s2.xref, s2);
                this.addInfo("Submitters collection was empty - repaired", this.gedcom);
            } else {
                this.addError("Submitters collection is empty", this.gedcom);
            }
            return;
        }
        for (Submitter s3 : this.gedcom.submitters.values()) {
            new SubmitterValidator(this.rootValidator, s3).validate();
        }
    }

    private void validateTrailer() {
        if (this.gedcom.trailer == null) {
            if (this.rootValidator.autorepair) {
                this.gedcom.trailer = new Trailer();
                this.rootValidator.addInfo("Gedcom had no trailer - repaired", this.gedcom);
            } else {
                this.rootValidator.addError("Gedcom has no trailer", this.gedcom);
            }
        }
    }
}

