/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.UserReference;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;

public class NoteValidator
extends AbstractValidator {
    private final Note n;
    private final int i;

    public NoteValidator(GedcomValidator rootValidator, int i, Note n) {
        this.rootValidator = rootValidator;
        this.i = i;
        this.n = n;
    }

    protected void validate() {
        if (this.n.lines == null) {
            if (this.rootValidator.autorepair) {
                this.n.lines = new ArrayList<String>();
                this.addInfo("Lines of text collection on note was null - autorepaired");
            } else {
                this.addError("Lines of text collection on note is null", this.n);
                return;
            }
        }
        if (this.n.xref == null && this.n.lines.isEmpty()) {
            this.addError("Note " + this.i + " without xref has no lines", this.n);
        }
        this.checkOptionalString(this.n.recIdNumber, "automated record id", (Object)this.n);
        if (this.n.citations == null) {
            if (this.rootValidator.autorepair) {
                this.n.citations = new ArrayList<AbstractCitation>();
                this.addInfo("Source citations collection on note was null - autorepaired");
            } else {
                this.addError("Source citations collection on note is null", this.n);
            }
        } else {
            for (AbstractCitation c : this.n.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
        if (this.n.userReferences == null) {
            if (this.rootValidator.autorepair) {
                this.n.userReferences = new ArrayList<UserReference>();
                this.addInfo("User references collection on note was null - autorepaired");
            } else {
                this.addError("User references collection on note is null", this.n);
            }
        } else {
            this.checkUserReferences(this.n.userReferences, this.n);
        }
        this.checkChangeDate(this.n.changeDate, this.n);
    }
}

