/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.io.GedcomFileWriter;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.Address;
import org.gedcom4j.model.Association;
import org.gedcom4j.model.ChangeDate;
import org.gedcom4j.model.CitationData;
import org.gedcom4j.model.CitationWithSource;
import org.gedcom4j.model.CitationWithoutSource;
import org.gedcom4j.model.Corporation;
import org.gedcom4j.model.Event;
import org.gedcom4j.model.EventRecorded;
import org.gedcom4j.model.Family;
import org.gedcom4j.model.FamilyChild;
import org.gedcom4j.model.FamilyEvent;
import org.gedcom4j.model.FamilySpouse;
import org.gedcom4j.model.FileReference;
import org.gedcom4j.model.Gedcom;
import org.gedcom4j.model.GedcomVersion;
import org.gedcom4j.model.Header;
import org.gedcom4j.model.HeaderSourceData;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.IndividualAttribute;
import org.gedcom4j.model.IndividualAttributeType;
import org.gedcom4j.model.IndividualEvent;
import org.gedcom4j.model.IndividualEventType;
import org.gedcom4j.model.LdsIndividualOrdinance;
import org.gedcom4j.model.LdsIndividualOrdinanceType;
import org.gedcom4j.model.LdsSpouseSealing;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.NameVariation;
import org.gedcom4j.model.Note;
import org.gedcom4j.model.PersonalName;
import org.gedcom4j.model.PersonalNameVariation;
import org.gedcom4j.model.Place;
import org.gedcom4j.model.Repository;
import org.gedcom4j.model.RepositoryCitation;
import org.gedcom4j.model.Source;
import org.gedcom4j.model.SourceCallNumber;
import org.gedcom4j.model.SourceData;
import org.gedcom4j.model.SourceSystem;
import org.gedcom4j.model.StringTree;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submission;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.model.SupportedVersion;
import org.gedcom4j.model.UserReference;
import org.gedcom4j.validate.GedcomValidationFinding;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.Severity;
import org.gedcom4j.writer.GedcomWriterException;
import org.gedcom4j.writer.GedcomWriterVersionDataMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomWriter {
    private static final int MAX_LINE_LENGTH = 128;
    private final Gedcom gedcom;
    boolean validationSuppressed = false;
    List<String> lines = new ArrayList<String>();
    public List<GedcomValidationFinding> validationFindings;
    public boolean autorepair = false;

    public GedcomWriter(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException, GedcomWriterException {
        this.gedcom.header.fileName = new StringWithCustomTags(file.getName());
        FileOutputStream o = new FileOutputStream(file);
        try {
            this.write(o);
            o.flush();
        }
        finally {
            ((OutputStream)o).close();
        }
    }

    public void write(OutputStream out) throws GedcomWriterException {
        this.write(out, true);
    }

    public void write(OutputStream out, boolean littleEndianForUnicode) throws GedcomWriterException {
        if (!this.validationSuppressed) {
            GedcomValidator gv = new GedcomValidator(this.gedcom);
            gv.autorepair = this.autorepair;
            gv.validate();
            this.validationFindings = gv.findings;
            int numErrorFindings = 0;
            for (GedcomValidationFinding f : this.validationFindings) {
                if (f.severity != Severity.ERROR) continue;
                ++numErrorFindings;
            }
            if (numErrorFindings > 0) {
                throw new GedcomWriterException("Cannot write file - " + numErrorFindings + " error(s) found during validation.  Review the validation findings to determine root cause.");
            }
        }
        this.checkVersionCompatibility();
        this.emitHeader();
        this.emitSubmissionRecord();
        this.emitRecords();
        this.emitTrailer();
        this.emitCustomTags(this.gedcom.customTags);
        try {
            GedcomFileWriter gfw = new GedcomFileWriter(this.lines);
            gfw.setLittleEndianForUnicode(littleEndianForUnicode);
            gfw.write(out);
        }
        catch (IOException e) {
            throw new GedcomWriterException("Unable to write file", e);
        }
    }

    public void write(String filename) throws IOException, GedcomWriterException {
        File f = new File(filename);
        this.write(f);
    }

    private void checkVersionCompatibility() throws GedcomWriterException {
        if (this.gedcom.header.gedcomVersion == null) {
            this.gedcom.header.gedcomVersion = new GedcomVersion();
        }
        if (SupportedVersion.V5_5.equals((Object)this.gedcom.header.gedcomVersion.versionNumber)) {
            this.checkVersionCompatibility55();
        } else {
            this.checkVersionCompatibility551();
        }
    }

    private void checkVersionCompatibility55() throws GedcomWriterVersionDataMismatchException {
        if (this.gedcom.header.copyrightData.size() > 1) {
            throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but has multi-line copyright data in header");
        }
        if (this.gedcom.header.characterSet != null && this.gedcom.header.characterSet.characterSetName != null && "UTF-8".equals(this.gedcom.header.characterSet.characterSetName.value)) {
            throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but data is encoded using UTF-8");
        }
        if (this.gedcom.header.sourceSystem != null && this.gedcom.header.sourceSystem.corporation != null) {
            Corporation c = this.gedcom.header.sourceSystem.corporation;
            if (!c.wwwUrls.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but source system corporation has www urls");
            }
            if (!c.faxNumbers.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but source system corporation has fax numbers");
            }
            if (!c.emails.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but source system corporation has emails");
            }
        }
        for (Individual i : this.gedcom.individuals.values()) {
            if (!i.wwwUrls.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has www urls");
            }
            if (!i.faxNumbers.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has fax numbers");
            }
            if (!i.emails.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has emails");
            }
            for (IndividualEvent e : i.events) {
                if (!e.wwwUrls.isEmpty()) {
                    throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has www urls on an event");
                }
                if (!e.faxNumbers.isEmpty()) {
                    throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has fax numbers on an event");
                }
                if (e.emails.isEmpty()) continue;
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has emails on an event");
            }
            for (IndividualAttribute a : i.attributes) {
                if (!IndividualAttributeType.FACT.equals((Object)a.type)) continue;
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " has a FACT attribute");
            }
            for (FamilyChild fc : i.familiesWhereChild) {
                if (fc.status == null) continue;
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Individual " + i.xref + " is in a family with a status specified (a Gedcom 5.5.1 only feature)");
            }
        }
        for (Submitter s2 : this.gedcom.submitters.values()) {
            if (!s2.wwwUrls.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Submitter " + s2.xref + " has www urls");
            }
            if (!s2.faxNumbers.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Submitter " + s2.xref + " has fax numbers");
            }
            if (s2.emails.isEmpty()) continue;
            throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Submitter " + s2.xref + " has emails");
        }
        for (Repository r : this.gedcom.repositories.values()) {
            if (!r.wwwUrls.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Repository " + r.xref + " has www urls");
            }
            if (!r.faxNumbers.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Repository " + r.xref + " has fax numbers");
            }
            if (r.emails.isEmpty()) continue;
            throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5, but Repository " + r.xref + " has emails");
        }
    }

    private void checkVersionCompatibility551() throws GedcomWriterVersionDataMismatchException {
        for (Multimedia m : this.gedcom.multimedia.values()) {
            if (m.blob.isEmpty()) continue;
            throw new GedcomWriterVersionDataMismatchException("Gedcom version is 5.5.1, but multimedia item " + m.xref + " contains BLOB data which is unsupported in 5.5.1");
        }
    }

    private void emitAddress(int level, Address address) {
        if (address == null) {
            return;
        }
        this.emitLinesOfText(level, "ADDR", address.lines);
        this.emitTagIfValueNotNull(level + 1, "ADR1", address.addr1);
        this.emitTagIfValueNotNull(level + 1, "ADR2", address.addr2);
        this.emitTagIfValueNotNull(level + 1, "CITY", address.city);
        this.emitTagIfValueNotNull(level + 1, "STAE", address.stateProvince);
        this.emitTagIfValueNotNull(level + 1, "POST", address.postalCode);
        this.emitTagIfValueNotNull(level + 1, "CTRY", address.country);
        this.emitCustomTags(address.customTags);
    }

    private void emitAndSplit(int level, String line) {
        if (line.length() <= 128) {
            this.lines.add(line);
        } else {
            this.lines.add(line.substring(0, 128));
            String remainder = line.substring(128);
            while (remainder.length() > 0) {
                if (remainder.length() > 128) {
                    this.lines.add(level + 1 + " CONC " + remainder.substring(0, 128));
                    remainder = remainder.substring(128);
                    continue;
                }
                this.lines.add(level + 1 + " CONC " + remainder);
                remainder = "";
            }
        }
    }

    private void emitAssociationStructures(int level, List<Association> associations) throws GedcomWriterException {
        for (Association a : associations) {
            this.emitTagWithRequiredValue(level, "ASSO", a.associatedEntityXref);
            this.emitTagWithRequiredValue(level + 1, "TYPE", a.associatedEntityType);
            this.emitTagWithRequiredValue(level + 1, "RELA", a.relationship);
            this.emitNotes(level + 1, a.notes);
            this.emitSourceCitations(level + 1, a.citations);
            this.emitCustomTags(a.customTags);
        }
    }

    private void emitChangeDate(int level, ChangeDate cd) throws GedcomWriterException {
        if (cd != null) {
            this.emitTag(level, "CHAN");
            this.emitTagWithRequiredValue(level + 1, "DATE", cd.date);
            this.emitTagIfValueNotNull(level + 2, "TIME", cd.time);
            this.emitNotes(level + 1, cd.notes);
            this.emitCustomTags(cd.customTags);
        }
    }

    private void emitChildToFamilyLinks(int level, Individual i) throws GedcomWriterException {
        for (FamilyChild familyChild : i.familiesWhereChild) {
            if (familyChild == null) {
                throw new GedcomWriterException("Family to which " + i + " was a child was null");
            }
            if (familyChild.family == null) {
                throw new GedcomWriterException("Family to which " + i + " was a child had a null family reference");
            }
            this.emitTagWithRequiredValue(level, "FAMC", familyChild.family.xref);
            this.emitTagIfValueNotNull(level + 1, "PEDI", familyChild.pedigree);
            this.emitTagIfValueNotNull(level + 1, "STAT", familyChild.status);
            this.emitNotes(level + 1, familyChild.notes);
            this.emitCustomTags(i.customTags);
        }
    }

    private void emitCitationWithoutSource(int level, AbstractCitation c) throws GedcomWriterException {
        CitationWithoutSource cws = (CitationWithoutSource)c;
        this.emitLinesOfText(level, "SOUR", cws.description);
        for (List<String> linesOfText : cws.textFromSource) {
            this.emitLinesOfText(level + 1, "TEXT", linesOfText);
        }
        this.emitNotes(level + 1, cws.notes);
        this.emitCustomTags(cws.customTags);
    }

    private void emitCitationWithSource(int level, CitationWithSource cws) throws GedcomWriterException {
        Source source = cws.source;
        if (source == null || source.xref == null || source.xref.length() == 0) {
            throw new GedcomWriterException("Citation with source must have a source record with an xref/id");
        }
        this.emitTagWithRequiredValue(level, "SOUR", source.xref);
        this.emitTagIfValueNotNull(level + 1, "PAGE", cws.whereInSource);
        this.emitTagIfValueNotNull(level + 1, "EVEN", cws.eventCited);
        this.emitTagIfValueNotNull(level + 2, "ROLE", cws.roleInEvent);
        if (cws.data != null && !cws.data.isEmpty()) {
            this.emitTag(level + 1, "DATA");
            for (CitationData cd : cws.data) {
                this.emitTagIfValueNotNull(level + 2, "DATE", cd.entryDate);
                for (List<String> linesOfText : cd.sourceText) {
                    this.emitLinesOfText(level + 2, "TEXT", linesOfText);
                }
            }
        }
        this.emitTagIfValueNotNull(level + 1, "QUAY", cws.certainty);
        this.emitMultimediaLinks(level + 1, cws.multimedia);
        this.emitNotes(level + 1, cws.notes);
        this.emitCustomTags(cws.customTags);
    }

    private void emitCustomTags(List<StringTree> customTags) {
        for (StringTree st : customTags) {
            StringBuilder line = new StringBuilder(Integer.toString(st.level));
            line.append(" ");
            if (st.id != null && st.id.trim().length() > 0) {
                line.append(st.id).append(" ");
            }
            line.append(st.tag);
            if (st.value != null && st.value.trim().length() > 0) {
                line.append(" ").append(st.value);
            }
            this.emitCustomTags(st.children);
        }
    }

    private void emitEmails(int l, List<StringWithCustomTags> emails) throws GedcomWriterException {
        for (StringWithCustomTags e : emails) {
            this.emitTagWithRequiredValue(l, "EMAIL", e);
        }
    }

    private void emitEventDetail(int level, Event e) throws GedcomWriterException {
        this.emitTagIfValueNotNull(level, "TYPE", e.subType);
        this.emitTagIfValueNotNull(level, "DATE", e.date);
        if (e.place != null) {
            Place p = e.place;
            this.emitPlace(level, p);
        }
        this.emitAddress(level, e.address);
        this.emitTagIfValueNotNull(level, "AGE", e.age);
        this.emitTagIfValueNotNull(level, "AGNC", e.respAgency);
        this.emitTagIfValueNotNull(level, "CAUS", e.cause);
        this.emitTagIfValueNotNull(level, "RELI", e.religiousAffiliation);
        this.emitTagIfValueNotNull(level, "RESN", e.restrictionNotice);
        this.emitSourceCitations(level, e.citations);
        this.emitMultimediaLinks(level, e.multimedia);
        this.emitNotes(level, e.notes);
        this.emitCustomTags(e.customTags);
    }

    private void emitFamilies() throws GedcomWriterException {
        for (Family f : this.gedcom.families.values()) {
            this.emitTag(0, f.xref, "FAM");
            for (FamilyEvent familyEvent : f.events) {
                this.emitFamilyEventStructure(1, familyEvent);
            }
            if (f.husband != null) {
                this.emitTagWithRequiredValue(1, "HUSB", f.husband.xref);
            }
            if (f.wife != null) {
                this.emitTagWithRequiredValue(1, "WIFE", f.wife.xref);
            }
            for (Individual individual : f.children) {
                this.emitTagWithRequiredValue(1, "CHIL", individual.xref);
            }
            this.emitTagIfValueNotNull(1, "NCHI", f.numChildren);
            for (Submitter submitter : f.submitters) {
                this.emitTagWithRequiredValue(1, "SUBM", submitter.xref);
            }
            for (LdsSpouseSealing ldsSpouseSealing : f.ldsSpouseSealings) {
                this.emitLdsFamilyOrdinance(1, ldsSpouseSealing);
            }
            this.emitTagIfValueNotNull(1, "RESN", f.restrictionNotice);
            this.emitSourceCitations(1, f.citations);
            this.emitMultimediaLinks(1, f.multimedia);
            this.emitNotes(1, f.notes);
            for (UserReference userReference : f.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", userReference.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", userReference.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", f.automatedRecordId);
            this.emitChangeDate(1, f.changeDate);
            this.emitCustomTags(f.customTags);
        }
    }

    private void emitFamilyEventStructure(int level, FamilyEvent e) throws GedcomWriterException {
        this.emitTagWithOptionalValue(level, e.type.tag, e.yNull);
        this.emitEventDetail(level + 1, e);
        if (e.husbandAge != null) {
            this.emitTag(level + 1, "HUSB");
            this.emitTagWithRequiredValue(level + 2, "AGE", e.husbandAge);
        }
        if (e.wifeAge != null) {
            this.emitTag(level + 1, "WIFE");
            this.emitTagWithRequiredValue(level + 2, "AGE", e.wifeAge);
        }
        this.emitCustomTags(e.customTags);
    }

    private void emitFaxNumbers(int l, List<StringWithCustomTags> faxNumbers) throws GedcomWriterException {
        for (StringWithCustomTags f : faxNumbers) {
            this.emitTagWithRequiredValue(l, "FAX", f);
        }
    }

    private void emitHeader() throws GedcomWriterException {
        Header header = this.gedcom.header;
        if (header == null) {
            header = new Header();
        }
        this.lines.add("0 HEAD");
        this.emitSourceSystem(header.sourceSystem);
        this.emitTagIfValueNotNull(1, "DEST", header.destinationSystem);
        if (header.date != null) {
            this.emitTagIfValueNotNull(1, "DATE", header.date);
            this.emitTagIfValueNotNull(2, "TIME", header.time);
        }
        if (header.submitter != null) {
            this.emitTagWithRequiredValue(1, "SUBM", header.submitter.xref);
        }
        if (header.submission != null) {
            this.emitTagWithRequiredValue(1, "SUBN", header.submission.xref);
        }
        this.emitTagIfValueNotNull(1, "FILE", header.fileName);
        this.emitLinesOfText(1, "COPR", header.copyrightData);
        this.emitTag(1, "GEDC");
        this.emitTagWithRequiredValue(2, "VERS", header.gedcomVersion.versionNumber.toString());
        this.emitTagWithRequiredValue(2, "FORM", header.gedcomVersion.gedcomForm);
        this.emitTagWithRequiredValue(1, "CHAR", header.characterSet.characterSetName);
        this.emitTagIfValueNotNull(2, "VERS", header.characterSet.versionNum);
        this.emitTagIfValueNotNull(1, "LANG", header.language);
        if (header.placeHierarchy != null && header.placeHierarchy.value != null && header.placeHierarchy.value.length() > 0) {
            this.emitTag(1, "PLAC");
            this.emitTagWithRequiredValue(2, "FORM", header.placeHierarchy);
        }
        this.emitNoteLines(1, null, header.notes);
        this.emitCustomTags(header.customTags);
    }

    private void emitIndividualAttributes(int level, List<IndividualAttribute> attributes) throws GedcomWriterException {
        for (IndividualAttribute a : attributes) {
            this.emitTagWithOptionalValueAndCustomSubtags(level, a.type.tag, a.description);
            this.emitEventDetail(level + 1, a);
            this.emitAddress(level + 1, a.address);
            this.emitPhoneNumbers(level + 1, a.phoneNumbers);
            this.emitWwwUrls(level + 1, a.wwwUrls);
            this.emitFaxNumbers(level + 1, a.faxNumbers);
            this.emitEmails(level + 1, a.emails);
            this.emitCustomTags(a.customTags);
        }
    }

    private void emitIndividualEvents(int level, List<IndividualEvent> events2) throws GedcomWriterException {
        for (IndividualEvent e : events2) {
            this.emitTagWithOptionalValue(level, e.type.tag, e.yNull);
            this.emitEventDetail(level + 1, e);
            if (e.type == IndividualEventType.BIRTH || e.type == IndividualEventType.CHRISTENING) {
                if (e.family != null && e.family.family != null && e.family.family.xref != null) {
                    this.emitTagWithRequiredValue(level + 1, "FAMC", e.family.family.xref);
                }
            } else if (e.type == IndividualEventType.ADOPTION && e.family != null && e.family.family != null && e.family.family.xref != null) {
                this.emitTagWithRequiredValue(level + 1, "FAMC", e.family.family.xref);
                this.emitTagIfValueNotNull(level + 2, "ADOP", (Object)e.family.adoptedBy);
            }
            this.emitCustomTags(e.customTags);
        }
    }

    private void emitIndividuals() throws GedcomWriterException {
        for (Individual i : this.gedcom.individuals.values()) {
            this.emitTag(0, i.xref, "INDI");
            this.emitTagIfValueNotNull(1, "RESN", i.restrictionNotice);
            this.emitPersonalNames(1, i.names);
            this.emitTagIfValueNotNull(1, "SEX", i.sex);
            this.emitIndividualEvents(1, i.events);
            this.emitIndividualAttributes(1, i.attributes);
            this.emitLdsIndividualOrdinances(1, i.ldsIndividualOrdinances);
            this.emitChildToFamilyLinks(1, i);
            this.emitSpouseInFamilyLinks(1, i);
            for (Submitter submitter : i.submitters) {
                this.emitTagWithRequiredValue(1, "SUBM", submitter.xref);
            }
            this.emitAssociationStructures(1, i.associations);
            for (StringWithCustomTags stringWithCustomTags : i.aliases) {
                this.emitTagWithRequiredValue(1, "ALIA", stringWithCustomTags);
            }
            for (Submitter submitter : i.ancestorInterest) {
                this.emitTagWithRequiredValue(1, "ANCI", submitter.xref);
            }
            for (Submitter submitter : i.descendantInterest) {
                this.emitTagWithRequiredValue(1, "DESI", submitter.xref);
            }
            this.emitSourceCitations(1, i.citations);
            this.emitMultimediaLinks(1, i.multimedia);
            this.emitNotes(1, i.notes);
            this.emitTagIfValueNotNull(1, "RFN", i.permanentRecFileNumber);
            this.emitTagIfValueNotNull(1, "AFN", i.ancestralFileNumber);
            for (UserReference userReference : i.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", userReference.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", userReference.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", i.recIdNumber);
            this.emitChangeDate(1, i.changeDate);
            this.emitCustomTags(i.customTags);
        }
    }

    private void emitLdsFamilyOrdinance(int level, LdsSpouseSealing sealings) throws GedcomWriterException {
        this.emitTag(level, "SLGS");
        this.emitTagIfValueNotNull(level + 1, "STAT", sealings.status);
        this.emitTagIfValueNotNull(level + 1, "DATE", sealings.date);
        this.emitTagIfValueNotNull(level + 1, "TEMP", sealings.temple);
        this.emitTagIfValueNotNull(level + 1, "PLAC", sealings.place);
        this.emitSourceCitations(level + 1, sealings.citations);
        this.emitNotes(level + 1, sealings.notes);
        this.emitCustomTags(sealings.customTags);
    }

    private void emitLdsIndividualOrdinances(int level, List<LdsIndividualOrdinance> ldsIndividualOrdinances) throws GedcomWriterException {
        for (LdsIndividualOrdinance o : ldsIndividualOrdinances) {
            this.emitTagWithOptionalValue(level, o.type.tag, o.yNull);
            this.emitTagIfValueNotNull(level + 1, "STAT", o.status);
            this.emitTagIfValueNotNull(level + 1, "DATE", o.date);
            this.emitTagIfValueNotNull(level + 1, "TEMP", o.temple);
            this.emitTagIfValueNotNull(level + 1, "PLAC", o.place);
            if (o.type == LdsIndividualOrdinanceType.CHILD_SEALING) {
                if (o.familyWhereChild == null) {
                    throw new GedcomWriterException("LDS Ordinance info for a child sealing had no reference to a family");
                }
                if (o.familyWhereChild.family == null) {
                    throw new GedcomWriterException("LDS Ordinance info for a child sealing had familyChild object with a null reference to a family");
                }
                this.emitTagWithRequiredValue(level + 1, "FAMC", o.familyWhereChild.family.xref);
            }
            this.emitSourceCitations(level + 1, o.citations);
            this.emitNotes(level + 1, o.notes);
            this.emitCustomTags(o.customTags);
        }
    }

    private void emitLinesOfText(int level, String startingTag, List<String> linesOfText) {
        this.emitLinesOfText(level, null, startingTag, linesOfText);
    }

    private void emitLinesOfText(int level, String xref, String startingTag, List<String> linesOfText) {
        int lineNum = 0;
        for (String l : linesOfText) {
            StringBuilder line = new StringBuilder();
            if (lineNum == 0) {
                line.append(level).append(" ");
                if (xref != null && xref.length() > 0) {
                    line.append(xref).append(" ");
                }
                line.append(startingTag).append(" ").append(l);
            } else {
                line.append(level + 1).append(" ");
                if (xref != null && xref.length() > 0) {
                    line.append(xref).append(" ");
                }
                line.append("CONT ").append(l);
            }
            ++lineNum;
            this.emitAndSplit(level, line.toString());
        }
    }

    private void emitMultimedia55() throws GedcomWriterException {
        for (Multimedia m : this.gedcom.multimedia.values()) {
            this.emitTag(0, m.xref, "OBJE");
            this.emitTagWithRequiredValue(1, "FORM", m.embeddedMediaFormat);
            this.emitTagIfValueNotNull(1, "TITL", m.embeddedTitle);
            this.emitNotes(1, m.notes);
            this.emitTag(1, "BLOB");
            for (String b : m.blob) {
                this.emitTagWithRequiredValue(2, "CONT", b);
            }
            if (m.continuedObject != null && m.continuedObject.xref != null) {
                this.emitTagWithRequiredValue(1, "OBJE", m.continuedObject.xref);
            }
            for (UserReference u : m.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", u.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", u.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", m.recIdNumber);
            this.emitChangeDate(1, m.changeDate);
            if (!m.fileReferences.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5, but found file references in multimedia object " + m.xref + " which are not allowed until GEDCOM 5.5.1");
            }
            this.emitCustomTags(m.customTags);
        }
    }

    private void emitMultimedia551() throws GedcomWriterException {
        for (Multimedia m : this.gedcom.multimedia.values()) {
            this.emitTag(0, m.xref, "OBJE");
            for (FileReference fr : m.fileReferences) {
                this.emitTagWithRequiredValue(1, "FILE", fr.referenceToFile);
                this.emitTagWithRequiredValue(2, "FORM", fr.format);
                this.emitTagIfValueNotNull(3, "TYPE", fr.mediaType);
                this.emitTagIfValueNotNull(2, "TITL", fr.title);
            }
            for (UserReference u : m.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", u.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", u.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", m.recIdNumber);
            this.emitNotes(1, m.notes);
            this.emitChangeDate(1, m.changeDate);
            this.emitCustomTags(m.customTags);
            if (!m.blob.isEmpty()) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5.1, but BLOB data on multimedia item " + m.xref + " was found.  This is only allowed in GEDCOM 5.5");
            }
            if (m.continuedObject != null) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5.1, but BLOB continuation data on multimedia item " + m.xref + " was found.  This is only allowed in GEDCOM 5.5");
            }
            if (m.embeddedMediaFormat != null) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5.1, but format on multimedia item " + m.xref + " was found.  This is only allowed in GEDCOM 5.5");
            }
            if (m.embeddedTitle == null) continue;
            throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5.1, but title on multimedia item " + m.xref + " was found.  This is only allowed in GEDCOM 5.5");
        }
    }

    private void emitMultimediaLinks(int level, List<Multimedia> multimedia) throws GedcomWriterException {
        if (multimedia == null) {
            return;
        }
        for (Multimedia m : multimedia) {
            if (m.xref != null) {
                this.emitTagWithRequiredValue(level, "OBJE", m.xref);
            } else if (this.g55()) {
                this.emitTag(level, "OBJE");
                if (m.fileReferences.size() > 1) {
                    throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5, but multimedia link references multiple files, which is only allowed in GEDCOM 5.5.1");
                }
                if (m.fileReferences.size() == 1) {
                    FileReference fr = m.fileReferences.get(0);
                    if (fr.format != null) {
                        this.emitTagWithRequiredValue(level + 1, "FORM", fr.format);
                    } else {
                        this.emitTagWithRequiredValue(level + 1, "FORM", m.embeddedMediaFormat);
                    }
                    this.emitTagIfValueNotNull(level + 1, "TITL", m.embeddedTitle);
                    this.emitTagWithRequiredValue(level + 1, "FILE", fr.referenceToFile);
                } else {
                    this.emitTagWithRequiredValue(level + 1, "FORM", m.embeddedMediaFormat);
                    this.emitTagIfValueNotNull(level + 1, "TITL", m.embeddedTitle);
                }
                this.emitNotes(level + 1, m.notes);
            } else {
                for (FileReference fr : m.fileReferences) {
                    this.emitTagWithRequiredValue(level + 1, "FILE", fr.referenceToFile);
                    this.emitTagIfValueNotNull(level + 2, "FORM", fr.format);
                    this.emitTagIfValueNotNull(level + 3, "MEDI", fr.mediaType);
                    this.emitTagIfValueNotNull(level + 1, "TITL", fr.title);
                }
                if (!m.notes.isEmpty()) {
                    throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5.1, but multimedia link has notes which are no longer allowed in 5.5");
                }
            }
            this.emitCustomTags(m.customTags);
        }
    }

    private void emitNote(int level, Note note) throws GedcomWriterException {
        if (level > 0 && note.xref != null) {
            this.emitTagWithRequiredValue(level, "NOTE", note.xref);
            return;
        }
        this.emitNoteLines(level, note.xref, note.lines);
        this.emitSourceCitations(level + 1, note.citations);
        for (UserReference u : note.userReferences) {
            this.emitTagWithRequiredValue(level + 1, "REFN", u.referenceNum);
            this.emitTagIfValueNotNull(level + 2, "TYPE", u.type);
        }
        this.emitTagIfValueNotNull(level + 1, "RIN", note.recIdNumber);
        this.emitChangeDate(level + 1, note.changeDate);
        this.emitCustomTags(note.customTags);
    }

    private void emitNoteLines(int level, String xref, List<String> noteLines) {
        this.emitLinesOfText(level, xref, "NOTE", noteLines);
    }

    private void emitNotes(int level, List<Note> notes) throws GedcomWriterException {
        for (Note n : notes) {
            this.emitNote(level, n);
            this.emitCustomTags(n.customTags);
        }
    }

    private void emitPersonalNames(int level, List<PersonalName> names) throws GedcomWriterException {
        for (PersonalName n : names) {
            this.emitTagWithOptionalValue(level, "NAME", n.basic);
            this.emitTagIfValueNotNull(level + 1, "NPFX", n.prefix);
            this.emitTagIfValueNotNull(level + 1, "GIVN", n.givenName);
            this.emitTagIfValueNotNull(level + 1, "NICK", n.nickname);
            this.emitTagIfValueNotNull(level + 1, "SPFX", n.surnamePrefix);
            this.emitTagIfValueNotNull(level + 1, "SURN", n.surname);
            this.emitTagIfValueNotNull(level + 1, "NSFX", n.suffix);
            for (PersonalNameVariation pnv : n.romanized) {
                this.emitPersonalNameVariation(level + 1, "ROMN", pnv);
            }
            for (PersonalNameVariation pnv : n.phonetic) {
                this.emitPersonalNameVariation(level + 1, "FONE", pnv);
            }
            this.emitSourceCitations(level + 1, n.citations);
            this.emitNotes(level + 1, n.notes);
            this.emitCustomTags(n.customTags);
        }
    }

    private void emitPersonalNameVariation(int level, String variationTag, PersonalNameVariation pnv) throws GedcomWriterException {
        this.emitTagWithRequiredValue(level, variationTag, pnv.variation);
        this.emitTagIfValueNotNull(level + 1, "NPFX", pnv.prefix);
        this.emitTagIfValueNotNull(level + 1, "GIVN", pnv.givenName);
        this.emitTagIfValueNotNull(level + 1, "NICK", pnv.nickname);
        this.emitTagIfValueNotNull(level + 1, "SPFX", pnv.surnamePrefix);
        this.emitTagIfValueNotNull(level + 1, "SURN", pnv.surname);
        this.emitTagIfValueNotNull(level + 1, "NSFX", pnv.suffix);
        this.emitSourceCitations(level + 1, pnv.citations);
        this.emitNotes(level + 1, pnv.notes);
        this.emitCustomTags(pnv.customTags);
    }

    private void emitPhoneNumbers(int level, List<StringWithCustomTags> phoneNumbers) {
        for (StringWithCustomTags ph : phoneNumbers) {
            this.emitTagIfValueNotNull(level, "PHON", ph);
        }
    }

    private void emitPlace(int level, Place p) throws GedcomWriterException {
        this.emitTagWithOptionalValue(level, "PLAC", p.placeName);
        this.emitTagIfValueNotNull(level + 1, "FORM", p.placeFormat);
        this.emitSourceCitations(level + 1, p.citations);
        this.emitNotes(level + 1, p.notes);
        for (NameVariation nv : p.romanized) {
            if (this.g55()) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5, but romanized variation was specified on place " + p.placeName + ", which is only allowed in GEDCOM 5.5.1");
            }
            this.emitTagWithRequiredValue(level + 1, "ROMN", nv.variation);
            this.emitTagIfValueNotNull(level + 2, "TYPE", nv.variationType);
        }
        for (NameVariation nv : p.phonetic) {
            if (this.g55()) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5, but phonetic variation was specified on place " + p.placeName + ", which is only allowed in GEDCOM 5.5.1");
            }
            this.emitTagWithRequiredValue(level + 1, "FONE", nv.variation);
            this.emitTagIfValueNotNull(level + 2, "TYPE", nv.variationType);
        }
        if (p.latitude != null || p.longitude != null) {
            this.emitTag(level + 1, "MAP");
            this.emitTagWithRequiredValue(level + 2, "LAT", p.latitude);
            this.emitTagWithRequiredValue(level + 2, "LONG", p.longitude);
            if (this.g55()) {
                throw new GedcomWriterVersionDataMismatchException("GEDCOM version is 5.5, but map coordinates were specified on place " + p.placeName + ", which is only allowed in GEDCOM 5.5.1");
            }
        }
        this.emitCustomTags(p.customTags);
    }

    private void emitRecords() throws GedcomWriterException {
        this.emitIndividuals();
        this.emitFamilies();
        if (this.g55()) {
            this.emitMultimedia55();
        } else {
            this.emitMultimedia551();
        }
        this.emitNotes(0, new ArrayList<Note>(this.gedcom.notes.values()));
        this.emitRepositories();
        this.emitSources();
        this.emitSubmitter();
    }

    private void emitRepositories() throws GedcomWriterException {
        for (Repository r : this.gedcom.repositories.values()) {
            this.emitTag(0, r.xref, "REPO");
            this.emitTagIfValueNotNull(1, "NAME", r.name);
            this.emitAddress(1, r.address);
            this.emitNotes(1, r.notes);
            for (UserReference u : r.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", u.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", u.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", r.recIdNumber);
            this.emitPhoneNumbers(1, r.phoneNumbers);
            this.emitWwwUrls(1, r.wwwUrls);
            this.emitFaxNumbers(1, r.faxNumbers);
            this.emitEmails(1, r.emails);
            this.emitChangeDate(1, r.changeDate);
            this.emitCustomTags(r.customTags);
        }
    }

    private void emitRepositoryCitation(int level, RepositoryCitation repositoryCitation) throws GedcomWriterException {
        if (repositoryCitation != null) {
            if (repositoryCitation.repositoryXref == null) {
                throw new GedcomWriterException("Repository Citation has null repository reference");
            }
            this.emitTagWithRequiredValue(level, "REPO", repositoryCitation.repositoryXref);
            this.emitNotes(level + 1, repositoryCitation.notes);
            for (SourceCallNumber scn : repositoryCitation.callNumbers) {
                this.emitTagWithRequiredValue(level + 1, "CALN", scn.callNumber);
                this.emitTagIfValueNotNull(level + 2, "MEDI", scn.mediaType);
            }
            this.emitCustomTags(repositoryCitation.customTags);
        }
    }

    private void emitSourceCitations(int level, List<AbstractCitation> citations) throws GedcomWriterException {
        if (citations == null) {
            return;
        }
        for (AbstractCitation c : citations) {
            if (c instanceof CitationWithoutSource) {
                this.emitCitationWithoutSource(level, c);
                continue;
            }
            if (!(c instanceof CitationWithSource)) continue;
            this.emitCitationWithSource(level, (CitationWithSource)c);
        }
    }

    private void emitSources() throws GedcomWriterException {
        for (Source s2 : this.gedcom.sources.values()) {
            this.emitTag(0, s2.xref, "SOUR");
            SourceData d = s2.data;
            if (d != null) {
                this.emitTag(1, "DATA");
                for (EventRecorded e : d.eventsRecorded) {
                    this.emitTagWithOptionalValue(2, "EVEN", e.eventType);
                    this.emitTagIfValueNotNull(3, "DATE", e.datePeriod);
                    this.emitTagIfValueNotNull(3, "PLAC", e.jurisdiction);
                }
                this.emitTagIfValueNotNull(2, "AGNC", d.respAgency);
                this.emitNotes(2, d.notes);
            }
            this.emitLinesOfText(1, "AUTH", s2.originatorsAuthors);
            this.emitLinesOfText(1, "TITL", s2.title);
            this.emitTagIfValueNotNull(1, "ABBR", s2.sourceFiledBy);
            this.emitLinesOfText(1, "PUBL", s2.publicationFacts);
            this.emitLinesOfText(1, "TEXT", s2.sourceText);
            this.emitRepositoryCitation(1, s2.repositoryCitation);
            this.emitMultimediaLinks(1, s2.multimedia);
            this.emitNotes(1, s2.notes);
            for (UserReference u : s2.userReferences) {
                this.emitTagWithRequiredValue(1, "REFN", u.referenceNum);
                this.emitTagIfValueNotNull(2, "TYPE", u.type);
            }
            this.emitTagIfValueNotNull(1, "RIN", s2.recIdNumber);
            this.emitChangeDate(1, s2.changeDate);
            this.emitCustomTags(s2.customTags);
        }
    }

    private void emitSourceSystem(SourceSystem sourceSystem) throws GedcomWriterException {
        HeaderSourceData sourceData;
        if (sourceSystem == null) {
            return;
        }
        this.emitTagWithRequiredValue(1, "SOUR", sourceSystem.systemId);
        this.emitTagIfValueNotNull(2, "VERS", sourceSystem.versionNum);
        this.emitTagIfValueNotNull(2, "NAME", sourceSystem.productName);
        Corporation corporation = sourceSystem.corporation;
        if (corporation != null) {
            this.emitTagWithOptionalValue(2, "CORP", corporation.businessName);
            this.emitAddress(3, corporation.address);
            this.emitPhoneNumbers(3, corporation.phoneNumbers);
            this.emitFaxNumbers(3, corporation.faxNumbers);
            this.emitWwwUrls(3, corporation.wwwUrls);
            this.emitEmails(3, corporation.emails);
        }
        if ((sourceData = sourceSystem.sourceData) != null) {
            this.emitTagIfValueNotNull(2, "DATA", sourceData.name);
            this.emitTagIfValueNotNull(3, "DATE", sourceData.publishDate);
            this.emitTagIfValueNotNull(3, "COPR", sourceData.copyright);
        }
        this.emitCustomTags(sourceSystem.customTags);
    }

    private void emitSpouseInFamilyLinks(int level, Individual i) throws GedcomWriterException {
        for (FamilySpouse familySpouse : i.familiesWhereSpouse) {
            if (familySpouse == null) {
                throw new GedcomWriterException("Family in which " + i + " was a spouse was null");
            }
            if (familySpouse.family == null) {
                throw new GedcomWriterException("Family in which " + i + " was a spouse had a null family reference");
            }
            this.emitTagWithRequiredValue(level, "FAMS", familySpouse.family.xref);
            this.emitNotes(level + 1, familySpouse.notes);
            this.emitCustomTags(familySpouse.customTags);
        }
    }

    private void emitSubmissionRecord() throws GedcomWriterException {
        Submission s2 = this.gedcom.submission;
        if (s2 == null) {
            return;
        }
        this.emitTag(0, s2.xref, "SUBN");
        if (s2.submitter != null) {
            this.emitTagWithOptionalValue(1, "SUBM", s2.submitter.xref);
        }
        this.emitTagIfValueNotNull(1, "FAMF", s2.nameOfFamilyFile);
        this.emitTagIfValueNotNull(1, "TEMP", s2.templeCode);
        this.emitTagIfValueNotNull(1, "ANCE", s2.ancestorsCount);
        this.emitTagIfValueNotNull(1, "DESC", s2.descendantsCount);
        this.emitTagIfValueNotNull(1, "ORDI", s2.ordinanceProcessFlag);
        this.emitTagIfValueNotNull(1, "RIN", s2.recIdNumber);
        this.emitCustomTags(s2.customTags);
    }

    private void emitSubmitter() throws GedcomWriterException {
        for (Submitter s2 : this.gedcom.submitters.values()) {
            this.emitTag(0, s2.xref, "SUBM");
            this.emitTagWithOptionalValueAndCustomSubtags(1, "NAME", s2.name);
            this.emitAddress(1, s2.address);
            this.emitMultimediaLinks(1, s2.multimedia);
            for (StringWithCustomTags l : s2.languagePref) {
                this.emitTagWithRequiredValue(1, "LANG", l);
            }
            this.emitPhoneNumbers(1, s2.phoneNumbers);
            this.emitWwwUrls(1, s2.wwwUrls);
            this.emitFaxNumbers(1, s2.faxNumbers);
            this.emitEmails(1, s2.emails);
            this.emitTagIfValueNotNull(1, "RFN", s2.regFileNumber);
            this.emitTagIfValueNotNull(1, "RIN", s2.recIdNumber);
            this.emitChangeDate(1, s2.changeDate);
            this.emitCustomTags(s2.customTags);
        }
    }

    private void emitTag(int level, String tag) {
        this.lines.add(level + " " + tag);
    }

    private void emitTag(int level, String xref, String tag) {
        StringBuilder line = new StringBuilder(Integer.toString(level));
        if (xref != null && xref.length() > 0) {
            line.append(" " + xref);
        }
        line.append(" " + tag);
        this.lines.add(line.toString());
    }

    private void emitTagIfValueNotNull(int level, String tag, Object value2) {
        this.emitTagIfValueNotNull(level, null, tag, value2);
    }

    private void emitTagIfValueNotNull(int level, String xref, String tag, Object value2) {
        if (value2 != null) {
            StringBuilder line = new StringBuilder();
            line.append(level);
            if (xref != null && xref.length() > 0) {
                line.append(" " + xref);
            }
            line.append(" " + tag + " " + value2);
            this.emitAndSplit(level, line.toString());
        }
    }

    private void emitTagWithOptionalValue(int level, String tag, String value2) throws GedcomWriterException {
        StringBuilder line = new StringBuilder(level + " " + tag);
        if (value2 != null) {
            line.append(" " + value2);
        }
        this.lines.add(line.toString());
    }

    private void emitTagWithOptionalValueAndCustomSubtags(int level, String tag, StringWithCustomTags valueToRightOfTag) throws GedcomWriterException {
        StringBuilder line = new StringBuilder(level + " " + tag);
        if (valueToRightOfTag != null && valueToRightOfTag.value != null) {
            line.append(" " + valueToRightOfTag);
        }
        this.lines.add(line.toString());
        if (valueToRightOfTag != null) {
            this.emitCustomTags(valueToRightOfTag.customTags);
        }
    }

    private void emitTagWithRequiredValue(int level, String tag, String value2) throws GedcomWriterException {
        this.emitTagWithRequiredValue(level, null, tag, new StringWithCustomTags(value2));
    }

    private void emitTagWithRequiredValue(int level, String xref, String tag, StringWithCustomTags e) throws GedcomWriterException {
        if (e == null || e.value == null || e.value.trim().length() == 0) {
            throw new GedcomWriterException("Required value for tag " + tag + " at level " + level + " was null or blank");
        }
        StringBuilder line = new StringBuilder(Integer.toString(level));
        if (xref != null && xref.length() > 0) {
            line.append(" " + xref);
        }
        line.append(" " + tag + " " + e);
        this.lines.add(line.toString());
        this.emitCustomTags(e.customTags);
    }

    private void emitTagWithRequiredValue(int level, String tag, StringWithCustomTags value2) throws GedcomWriterException {
        this.emitTagWithRequiredValue(level, null, tag, value2);
    }

    private void emitTrailer() {
        this.lines.add("0 TRLR");
    }

    private void emitWwwUrls(int l, List<StringWithCustomTags> wwwUrls) throws GedcomWriterException {
        for (StringWithCustomTags w : wwwUrls) {
            this.emitTagWithRequiredValue(l, "WWW", w);
        }
    }

    private boolean g55() {
        return this.gedcom != null && this.gedcom.header != null && this.gedcom.header.gedcomVersion != null && SupportedVersion.V5_5.equals((Object)this.gedcom.header.gedcomVersion.versionNumber);
    }
}

