/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;

class NamespaceHelper {
    private XMLLibImpl lib;
    private final Map prefixToURI = new HashMap();
    private final Map uriToPrefix = new HashMap();
    private final Set undeclared = new HashSet();

    private NamespaceHelper(XMLLibImpl xMLLibImpl) {
        this.lib = xMLLibImpl;
        this.prefixToURI.put("", "");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("");
        this.uriToPrefix.put("", hashSet);
    }

    private void declareNamespace(String string2, String string3, ObjArray objArray) {
        Set set = (HashSet<String>)this.uriToPrefix.get(string3);
        if (set == null) {
            set = new HashSet<String>();
            this.uriToPrefix.put(string3, set);
        }
        if (!set.contains(string2)) {
            String string4 = (String)this.prefixToURI.get(string2);
            set.add(string2);
            this.prefixToURI.put(string2, string3);
            if (objArray != null) {
                objArray.add(new Namespace(this.lib, string2, string3));
            }
            if (string4 != null) {
                set = (Set)this.uriToPrefix.get(string4);
                set.remove(string2);
            }
        }
    }

    private void processName(XmlCursor xmlCursor, ObjArray objArray) {
        QName qName = xmlCursor.getName();
        String string2 = qName.getNamespaceURI();
        Set set = (Set)this.uriToPrefix.get(string2);
        if (set == null || set.size() == 0) {
            this.undeclared.add(string2);
            if (objArray != null) {
                objArray.add(new Namespace(this.lib, string2));
            }
        }
    }

    private void update(XmlCursor xmlCursor, ObjArray objArray) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            if (!xmlCursor.isNamespace()) continue;
            QName qName = xmlCursor.getName();
            String string2 = qName.getLocalPart();
            String string3 = qName.getNamespaceURI();
            this.declareNamespace(string2, string3, objArray);
        }
        xmlCursor.pop();
        this.processName(xmlCursor, objArray);
        xmlCursor.push();
        boolean bl = xmlCursor.toFirstAttribute();
        while (bl) {
            this.processName(xmlCursor, objArray);
            bl = xmlCursor.toNextAttribute();
        }
        xmlCursor.pop();
    }

    public static Object[] inScopeNamespaces(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        Object object;
        ObjArray objArray = new ObjArray();
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        Iterator iterator2 = namespaceHelper.prefixToURI.entrySet().iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            Namespace namespace = new Namespace(xMLLibImpl, (String)object.getKey(), (String)object.getValue());
            objArray.add(namespace);
        }
        iterator2 = namespaceHelper.undeclared.iterator();
        while (iterator2.hasNext()) {
            object = new Namespace(xMLLibImpl, (String)((Object)iterator2.next()));
            objArray.add(object);
        }
        xmlCursor.pop();
        return objArray.toArray();
    }

    static Namespace getNamespace(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor, Object[] objectArray) {
        Serializable serializable2;
        String string2;
        String string3;
        if (xmlCursor.isProcinst()) {
            string3 = "";
            string2 = "";
        } else {
            serializable2 = xmlCursor.getName();
            string3 = ((QName)serializable2).getNamespaceURI();
            string2 = ((QName)serializable2).getPrefix();
        }
        if (objectArray == null) {
            return new Namespace(xMLLibImpl, string2, string3);
        }
        serializable2 = null;
        for (int i = 0; i != objectArray.length; ++i) {
            String string4;
            Namespace namespace = (Namespace)objectArray[i];
            if (namespace == null || !(string4 = namespace.uri()).equals(string3)) continue;
            if (string2.equals(namespace.prefix())) {
                serializable2 = namespace;
                break;
            }
            if (serializable2 != null && (((Namespace)serializable2).prefix() != null || namespace.prefix() == null)) continue;
            serializable2 = namespace;
        }
        if (serializable2 == null) {
            serializable2 = new Namespace(xMLLibImpl, string2, string3);
        }
        return serializable2;
    }

    public static Object[] namespaceDeclarations(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        ObjArray objArray = new ObjArray();
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n - 1; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        if (n > 0) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, objArray);
        }
        xmlCursor.pop();
        return objArray.toArray();
    }

    public static Map getAllNamespaces(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        xmlCursor.pop();
        return namespaceHelper.prefixToURI;
    }

    public static void getNamespaces(XmlCursor xmlCursor, Map map2) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            if (!xmlCursor.isNamespace()) continue;
            QName qName = xmlCursor.getName();
            String string2 = qName.getLocalPart();
            String string3 = qName.getNamespaceURI();
            map2.put(string2, string3);
        }
        xmlCursor.pop();
    }

    public static void removeNamespace(XmlCursor xmlCursor, String string2) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            QName qName;
            if (!xmlCursor.isNamespace() || !(qName = xmlCursor.getName()).getLocalPart().equals(string2)) continue;
            xmlCursor.removeXml();
            break;
        }
        xmlCursor.pop();
    }
}

