/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;

final class QName
extends IdScriptableObject {
    static final long serialVersionUID = 416745167693026750L;
    private static final Object QNAME_TAG = new Object();
    XMLLibImpl lib;
    private String prefix;
    private String localName;
    private String uri;
    private static final int Id_localName = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    QName(XMLLibImpl xMLLibImpl, String string2, String string3, String string4) {
        super(xMLLibImpl.globalScope(), xMLLibImpl.qnamePrototype);
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        this.lib = xMLLibImpl;
        this.uri = string2;
        this.prefix = string4;
        this.localName = string3;
    }

    void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.lib.globalScope(), bl);
    }

    public String toString() {
        String string2 = this.uri == null ? "*::".concat(this.localName) : (this.uri.length() == 0 ? this.localName : this.uri + "::" + this.localName);
        return string2;
    }

    public String localName() {
        return this.localName;
    }

    String prefix() {
        return this.prefix == null ? this.prefix : "";
    }

    String uri() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return false;
        }
        return this.equals((QName)object);
    }

    protected Object equivalentValues(Object object) {
        if (!(object instanceof QName)) {
            return Scriptable.NOT_FOUND;
        }
        boolean bl = this.equals((QName)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean equals(QName qName) {
        boolean bl = this.uri == null ? qName.uri == null && this.localName.equals(qName.localName) : this.uri.equals(qName.uri) && this.localName.equals(qName.localName);
        return bl;
    }

    public String getClassName() {
        return "QName";
    }

    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    protected int findInstanceIdInfo(String string2) {
        int n;
        int n2 = 0;
        String string3 = null;
        int n3 = string2.length();
        if (n3 == 3) {
            string3 = "uri";
            n2 = 2;
        } else if (n3 == 9) {
            string3 = "localName";
            n2 = 1;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string2);
        }
        switch (n2) {
            case 1: 
            case 2: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return QName.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "localName";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return this.localName;
            }
            case 2: {
                return this.uri;
            }
        }
        return super.getInstanceIdValue(n);
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        int n2 = string2.length();
        if (n2 == 8) {
            char c = string2.charAt(3);
            if (c == 'o') {
                string3 = "toSource";
                n = 3;
            } else if (c == 't') {
                string3 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string3 = "constructor";
            n = 1;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string2 = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string2 = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(QNAME_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(QNAME_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.jsConstructor(context, scriptable2 == null, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).toString();
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private QName realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof QName)) {
            throw QName.incompatibleCallError(idFunctionObject);
        }
        return (QName)scriptable;
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.lib.castToQName(context, objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.lib.constructQName(context, Undefined.instance);
        }
        if (objectArray.length == 1) {
            return this.lib.constructQName(context, objectArray[0]);
        }
        return this.lib.constructQName(context, objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        QName.toSourceImpl(this.uri, this.localName, this.prefix, stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static void toSourceImpl(String string2, String string3, String string4, StringBuffer stringBuffer) {
        stringBuffer.append("new QName(");
        if (string2 == null && string4 == null) {
            if (!"*".equals(string3)) {
                stringBuffer.append("null, ");
            }
        } else {
            Namespace.toSourceImpl(string4, string2, stringBuffer);
            stringBuffer.append(", ");
        }
        stringBuffer.append('\'');
        stringBuffer.append(ScriptRuntime.escapeString(string3, '\''));
        stringBuffer.append("')");
    }
}

