/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api._internal;

import com.droidkit.actors.ActorRef;
import com.droidkit.actors.concurrency.Future;
import com.droidkit.actors.tasks.AskCallback;
import com.droidkit.actors.typed.TypedActor;
import com.droidkit.actors.typed.TypedFuture;
import im.actor.api._internal.RawRequestActor;
import im.actor.api._internal.TypedRequestInt;
import im.actor.api.parser.Request;
import im.actor.api.parser.Response;
import java.util.concurrent.atomic.AtomicLong;

public class TypedRequestActor
extends TypedActor<TypedRequestInt>
implements TypedRequestInt {
    private static final AtomicLong NEXT_RPC_ID = new AtomicLong(1L);
    private ActorRef broker;

    public TypedRequestActor(ActorRef broker) {
        super(TypedRequestInt.class);
        this.broker = broker;
    }

    @Override
    public Future<Response> request(Request message) {
        final TypedFuture res = this.future();
        this.ask(RawRequestActor.request(this.getPath() + "/" + NEXT_RPC_ID.incrementAndGet(), NEXT_RPC_ID.getAndIncrement(), message, this.broker), (AskCallback)new AskCallback<Response>(){

            public void onResult(Response result) {
                res.doComplete((Object)result);
            }

            public void onError(Throwable throwable) {
                res.doError(throwable);
            }
        });
        return res;
    }

    @Override
    public Future<Response> request(Request message, long timeout) {
        final TypedFuture res = this.future();
        this.ask(RawRequestActor.request(this.getPath() + "/" + NEXT_RPC_ID.incrementAndGet(), NEXT_RPC_ID.getAndIncrement(), message, this.broker), timeout, (AskCallback)new AskCallback<Response>(){

            public void onResult(Response result) {
                res.doComplete((Object)result);
            }

            public void onError(Throwable throwable) {
                res.doError(throwable);
            }
        });
        return res;
    }
}

