package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CIBindingTemplateBuilder extends V1alpha1CIBindingTemplateFluentImpl<V1alpha1CIBindingTemplateBuilder> implements VisitableBuilder<V1alpha1CIBindingTemplate,V1alpha1CIBindingTemplateBuilder>{

    V1alpha1CIBindingTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CIBindingTemplateBuilder(){
            this(true);
    }
    public V1alpha1CIBindingTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1CIBindingTemplate(), validationEnabled);
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CIBindingTemplate(), validationEnabled);
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplateFluent<?> fluent,V1alpha1CIBindingTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplateFluent<?> fluent,V1alpha1CIBindingTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplate instance){
            this(instance,true);
    }
    public V1alpha1CIBindingTemplateBuilder(V1alpha1CIBindingTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CIBindingTemplate build(){
            V1alpha1CIBindingTemplate buildable = new V1alpha1CIBindingTemplate();
            buildable.setSelector(fluent.getSelector());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CIBindingTemplateBuilder that = (V1alpha1CIBindingTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
