package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityAnalyzeMetricBuilder extends V1alpha1CodeQualityAnalyzeMetricFluentImpl<V1alpha1CodeQualityAnalyzeMetricBuilder> implements VisitableBuilder<V1alpha1CodeQualityAnalyzeMetric,V1alpha1CodeQualityAnalyzeMetricBuilder>{

    V1alpha1CodeQualityAnalyzeMetricFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityAnalyzeMetricBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityAnalyzeMetric(), validationEnabled);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetricFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetricFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityAnalyzeMetric(), validationEnabled);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetricFluent<?> fluent,V1alpha1CodeQualityAnalyzeMetric instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetricFluent<?> fluent,V1alpha1CodeQualityAnalyzeMetric instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLevel(instance.getLevel());

            fluent.withName(instance.getName());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetric instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityAnalyzeMetricBuilder(V1alpha1CodeQualityAnalyzeMetric instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLevel(instance.getLevel());

            this.withName(instance.getName());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityAnalyzeMetric build(){
            V1alpha1CodeQualityAnalyzeMetric buildable = new V1alpha1CodeQualityAnalyzeMetric();
            buildable.setLevel(fluent.getLevel());
            buildable.setName(fluent.getName());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityAnalyzeMetricBuilder that = (V1alpha1CodeQualityAnalyzeMetricBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
