package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityProjectListBuilder extends V1alpha1CodeQualityProjectListFluentImpl<V1alpha1CodeQualityProjectListBuilder> implements VisitableBuilder<V1alpha1CodeQualityProjectList,V1alpha1CodeQualityProjectListBuilder>{

    V1alpha1CodeQualityProjectListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityProjectListBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityProjectListBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityProjectList(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityProjectList(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectListFluent<?> fluent,V1alpha1CodeQualityProjectList instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectListFluent<?> fluent,V1alpha1CodeQualityProjectList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectList instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityProjectListBuilder(V1alpha1CodeQualityProjectList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityProjectList build(){
            V1alpha1CodeQualityProjectList buildable = new V1alpha1CodeQualityProjectList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityProjectListBuilder that = (V1alpha1CodeQualityProjectListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
