package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityTemplateBuilder extends V1alpha1CodeQualityTemplateFluentImpl<V1alpha1CodeQualityTemplateBuilder> implements VisitableBuilder<V1alpha1CodeQualityTemplate,V1alpha1CodeQualityTemplateBuilder>{

    V1alpha1CodeQualityTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityTemplateBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityTemplate(), validationEnabled);
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityTemplate(), validationEnabled);
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplateFluent<?> fluent,V1alpha1CodeQualityTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplateFluent<?> fluent,V1alpha1CodeQualityTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplate instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityTemplateBuilder(V1alpha1CodeQualityTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityTemplate build(){
            V1alpha1CodeQualityTemplate buildable = new V1alpha1CodeQualityTemplate();
            buildable.setSelector(fluent.getSelector());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityTemplateBuilder that = (V1alpha1CodeQualityTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
