package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceAuthorizeOptionsBuilder extends V1alpha1CodeRepoServiceAuthorizeOptionsFluentImpl<V1alpha1CodeRepoServiceAuthorizeOptionsBuilder> implements VisitableBuilder<V1alpha1CodeRepoServiceAuthorizeOptions,V1alpha1CodeRepoServiceAuthorizeOptionsBuilder>{

    V1alpha1CodeRepoServiceAuthorizeOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoServiceAuthorizeOptions(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoServiceAuthorizeOptions(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptionsFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptionsFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNamespace(instance.getNamespace());

            fluent.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptions instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoServiceAuthorizeOptionsBuilder(V1alpha1CodeRepoServiceAuthorizeOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNamespace(instance.getNamespace());

            this.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoServiceAuthorizeOptions build(){
            V1alpha1CodeRepoServiceAuthorizeOptions buildable = new V1alpha1CodeRepoServiceAuthorizeOptions();
            buildable.setNamespace(fluent.getNamespace());
            buildable.setSecretName(fluent.getSecretName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceAuthorizeOptionsBuilder that = (V1alpha1CodeRepoServiceAuthorizeOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
