package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ConstValuesBuilder extends V1alpha1ConstValuesFluentImpl<V1alpha1ConstValuesBuilder> implements VisitableBuilder<V1alpha1ConstValues,V1alpha1ConstValuesBuilder>{

    V1alpha1ConstValuesFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ConstValuesBuilder(){
            this(true);
    }
    public V1alpha1ConstValuesBuilder(Boolean validationEnabled){
            this(new V1alpha1ConstValues(), validationEnabled);
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValuesFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValuesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ConstValues(), validationEnabled);
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValuesFluent<?> fluent,V1alpha1ConstValues instance){
            this(fluent, instance, true);
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValuesFluent<?> fluent,V1alpha1ConstValues instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValues instance){
            this(instance,true);
    }
    public V1alpha1ConstValuesBuilder(V1alpha1ConstValues instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ConstValues build(){
            V1alpha1ConstValues buildable = new V1alpha1ConstValues();
            buildable.setTasks(fluent.getTasks());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ConstValuesBuilder that = (V1alpha1ConstValuesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
