package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementListBuilder extends V1alpha1DocumentManagementListFluentImpl<V1alpha1DocumentManagementListBuilder> implements VisitableBuilder<V1alpha1DocumentManagementList,V1alpha1DocumentManagementListBuilder>{

    V1alpha1DocumentManagementListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DocumentManagementListBuilder(){
            this(true);
    }
    public V1alpha1DocumentManagementListBuilder(Boolean validationEnabled){
            this(new V1alpha1DocumentManagementList(), validationEnabled);
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DocumentManagementList(), validationEnabled);
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementListFluent<?> fluent,V1alpha1DocumentManagementList instance){
            this(fluent, instance, true);
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementListFluent<?> fluent,V1alpha1DocumentManagementList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementList instance){
            this(instance,true);
    }
    public V1alpha1DocumentManagementListBuilder(V1alpha1DocumentManagementList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DocumentManagementList build(){
            V1alpha1DocumentManagementList buildable = new V1alpha1DocumentManagementList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementListBuilder that = (V1alpha1DocumentManagementListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
