package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1MultiBranchBehavioursBuilder extends V1alpha1MultiBranchBehavioursFluentImpl<V1alpha1MultiBranchBehavioursBuilder> implements VisitableBuilder<V1alpha1MultiBranchBehaviours,V1alpha1MultiBranchBehavioursBuilder>{

    V1alpha1MultiBranchBehavioursFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1MultiBranchBehavioursBuilder(){
            this(true);
    }
    public V1alpha1MultiBranchBehavioursBuilder(Boolean validationEnabled){
            this(new V1alpha1MultiBranchBehaviours(), validationEnabled);
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehavioursFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehavioursFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1MultiBranchBehaviours(), validationEnabled);
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehavioursFluent<?> fluent,V1alpha1MultiBranchBehaviours instance){
            this(fluent, instance, true);
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehavioursFluent<?> fluent,V1alpha1MultiBranchBehaviours instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDiscoverBranches(instance.getDiscoverBranches());

            fluent.withDiscoverPRFromForks(instance.getDiscoverPRFromForks());

            fluent.withDiscoverPRFromOrigin(instance.getDiscoverPRFromOrigin());

            fluent.withDiscoverTags(instance.isDiscoverTags());

            fluent.withFilterExpression(instance.getFilterExpression());

            fluent.withForksTrust(instance.getForksTrust());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehaviours instance){
            this(instance,true);
    }
    public V1alpha1MultiBranchBehavioursBuilder(V1alpha1MultiBranchBehaviours instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDiscoverBranches(instance.getDiscoverBranches());

            this.withDiscoverPRFromForks(instance.getDiscoverPRFromForks());

            this.withDiscoverPRFromOrigin(instance.getDiscoverPRFromOrigin());

            this.withDiscoverTags(instance.isDiscoverTags());

            this.withFilterExpression(instance.getFilterExpression());

            this.withForksTrust(instance.getForksTrust());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1MultiBranchBehaviours build(){
            V1alpha1MultiBranchBehaviours buildable = new V1alpha1MultiBranchBehaviours();
            buildable.setDiscoverBranches(fluent.getDiscoverBranches());
            buildable.setDiscoverPRFromForks(fluent.getDiscoverPRFromForks());
            buildable.setDiscoverPRFromOrigin(fluent.getDiscoverPRFromOrigin());
            buildable.setDiscoverTags(fluent.isDiscoverTags());
            buildable.setFilterExpression(fluent.getFilterExpression());
            buildable.setForksTrust(fluent.getForksTrust());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1MultiBranchBehavioursBuilder that = (V1alpha1MultiBranchBehavioursBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
