package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigListBuilder extends V1alpha1PipelineConfigListFluentImpl<V1alpha1PipelineConfigListBuilder> implements VisitableBuilder<V1alpha1PipelineConfigList,V1alpha1PipelineConfigListBuilder>{

    V1alpha1PipelineConfigListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigListBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigListBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigList(), validationEnabled);
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigList(), validationEnabled);
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigListFluent<?> fluent,V1alpha1PipelineConfigList instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigListFluent<?> fluent,V1alpha1PipelineConfigList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigList instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigListBuilder(V1alpha1PipelineConfigList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigList build(){
            V1alpha1PipelineConfigList buildable = new V1alpha1PipelineConfigList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigListBuilder that = (V1alpha1PipelineConfigListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
