package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineEnvironmentBuilder extends V1alpha1PipelineEnvironmentFluentImpl<V1alpha1PipelineEnvironmentBuilder> implements VisitableBuilder<V1alpha1PipelineEnvironment,V1alpha1PipelineEnvironmentBuilder>{

    V1alpha1PipelineEnvironmentFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineEnvironmentBuilder(){
            this(true);
    }
    public V1alpha1PipelineEnvironmentBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineEnvironment(), validationEnabled);
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironmentFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironmentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineEnvironment(), validationEnabled);
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironmentFluent<?> fluent,V1alpha1PipelineEnvironment instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironmentFluent<?> fluent,V1alpha1PipelineEnvironment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironment instance){
            this(instance,true);
    }
    public V1alpha1PipelineEnvironmentBuilder(V1alpha1PipelineEnvironment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineEnvironment build(){
            V1alpha1PipelineEnvironment buildable = new V1alpha1PipelineEnvironment();
            buildable.setName(fluent.getName());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineEnvironmentBuilder that = (V1alpha1PipelineEnvironmentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
