package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskOptionBuilder extends V1alpha1PipelineTaskOptionFluentImpl<V1alpha1PipelineTaskOptionBuilder> implements VisitableBuilder<V1alpha1PipelineTaskOption,V1alpha1PipelineTaskOptionBuilder>{

    V1alpha1PipelineTaskOptionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskOptionBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskOptionBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskOption(), validationEnabled);
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOptionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOptionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskOption(), validationEnabled);
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOptionFluent<?> fluent,V1alpha1PipelineTaskOption instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOptionFluent<?> fluent,V1alpha1PipelineTaskOption instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOption instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskOptionBuilder(V1alpha1PipelineTaskOption instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskOption build(){
            V1alpha1PipelineTaskOption buildable = new V1alpha1PipelineTaskOption();
            buildable.setTimeout(fluent.getTimeout());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskOptionBuilder that = (V1alpha1PipelineTaskOptionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
