package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSyncConditionBuilder extends V1alpha1PipelineTemplateSyncConditionFluentImpl<V1alpha1PipelineTemplateSyncConditionBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateSyncCondition,V1alpha1PipelineTemplateSyncConditionBuilder>{

    V1alpha1PipelineTemplateSyncConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateSyncConditionBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateSyncCondition(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateSyncCondition(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncConditionFluent<?> fluent,V1alpha1PipelineTemplateSyncCondition instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncConditionFluent<?> fluent,V1alpha1PipelineTemplateSyncCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withLastUpdateTime(instance.getLastUpdateTime());

            fluent.withMessage(instance.getMessage());

            fluent.withName(instance.getName());

            fluent.withPreviousVersion(instance.getPreviousVersion());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withTarget(instance.getTarget());

            fluent.withType(instance.getType());

            fluent.withVersion(instance.getVersion());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncCondition instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateSyncConditionBuilder(V1alpha1PipelineTemplateSyncCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withLastUpdateTime(instance.getLastUpdateTime());

            this.withMessage(instance.getMessage());

            this.withName(instance.getName());

            this.withPreviousVersion(instance.getPreviousVersion());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withTarget(instance.getTarget());

            this.withType(instance.getType());

            this.withVersion(instance.getVersion());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateSyncCondition build(){
            V1alpha1PipelineTemplateSyncCondition buildable = new V1alpha1PipelineTemplateSyncCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setLastUpdateTime(fluent.getLastUpdateTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setName(fluent.getName());
            buildable.setPreviousVersion(fluent.getPreviousVersion());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setTarget(fluent.getTarget());
            buildable.setType(fluent.getType());
            buildable.setVersion(fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSyncConditionBuilder that = (V1alpha1PipelineTemplateSyncConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
