package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSyncListBuilder extends V1alpha1PipelineTemplateSyncListFluentImpl<V1alpha1PipelineTemplateSyncListBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateSyncList,V1alpha1PipelineTemplateSyncListBuilder>{

    V1alpha1PipelineTemplateSyncListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateSyncListBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateSyncList(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateSyncList(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncListFluent<?> fluent,V1alpha1PipelineTemplateSyncList instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncListFluent<?> fluent,V1alpha1PipelineTemplateSyncList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncList instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateSyncListBuilder(V1alpha1PipelineTemplateSyncList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateSyncList build(){
            V1alpha1PipelineTemplateSyncList buildable = new V1alpha1PipelineTemplateSyncList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSyncListBuilder that = (V1alpha1PipelineTemplateSyncListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
