package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTriggerBuilder extends V1alpha1PipelineTriggerFluentImpl<V1alpha1PipelineTriggerBuilder> implements VisitableBuilder<V1alpha1PipelineTrigger,V1alpha1PipelineTriggerBuilder>{

    V1alpha1PipelineTriggerFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTriggerBuilder(){
            this(true);
    }
    public V1alpha1PipelineTriggerBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTrigger(), validationEnabled);
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTriggerFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTriggerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTrigger(), validationEnabled);
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTriggerFluent<?> fluent,V1alpha1PipelineTrigger instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTriggerFluent<?> fluent,V1alpha1PipelineTrigger instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCodeChange(instance.getCodeChange());

            fluent.withCron(instance.getCron());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTrigger instance){
            this(instance,true);
    }
    public V1alpha1PipelineTriggerBuilder(V1alpha1PipelineTrigger instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCodeChange(instance.getCodeChange());

            this.withCron(instance.getCron());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTrigger build(){
            V1alpha1PipelineTrigger buildable = new V1alpha1PipelineTrigger();
            buildable.setCodeChange(fluent.getCodeChange());
            buildable.setCron(fluent.getCron());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTriggerBuilder that = (V1alpha1PipelineTriggerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
