package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ProjectUserRoleOperationBuilder extends V1alpha1ProjectUserRoleOperationFluentImpl<V1alpha1ProjectUserRoleOperationBuilder> implements VisitableBuilder<V1alpha1ProjectUserRoleOperation,V1alpha1ProjectUserRoleOperationBuilder>{

    V1alpha1ProjectUserRoleOperationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ProjectUserRoleOperationBuilder(){
            this(true);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(Boolean validationEnabled){
            this(new V1alpha1ProjectUserRoleOperation(), validationEnabled);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperationFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ProjectUserRoleOperation(), validationEnabled);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperationFluent<?> fluent,V1alpha1ProjectUserRoleOperation instance){
            this(fluent, instance, true);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperationFluent<?> fluent,V1alpha1ProjectUserRoleOperation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject());

            fluent.withUserRoleOperations(instance.getUserRoleOperations());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperation instance){
            this(instance,true);
    }
    public V1alpha1ProjectUserRoleOperationBuilder(V1alpha1ProjectUserRoleOperation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject());

            this.withUserRoleOperations(instance.getUserRoleOperations());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ProjectUserRoleOperation build(){
            V1alpha1ProjectUserRoleOperation buildable = new V1alpha1ProjectUserRoleOperation();
            buildable.setProject(fluent.getProject());
            buildable.setUserRoleOperations(fluent.getUserRoleOperations());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectUserRoleOperationBuilder that = (V1alpha1ProjectUserRoleOperationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
