package io.alauda.devops.java.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1alpha1RepositoryCommitFluentImpl<A extends V1alpha1RepositoryCommitFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1RepositoryCommitFluent<A>{

    private DateTime commitAt;
    private String commitID;
    private String commitMessage;
    private String committerEmail;
    private String committerName;

    public V1alpha1RepositoryCommitFluentImpl(){
    }
    public V1alpha1RepositoryCommitFluentImpl(V1alpha1RepositoryCommit instance){
            this.withCommitAt(instance.getCommitAt());

            this.withCommitID(instance.getCommitID());

            this.withCommitMessage(instance.getCommitMessage());

            this.withCommitterEmail(instance.getCommitterEmail());

            this.withCommitterName(instance.getCommitterName());

    }

    public DateTime getCommitAt(){
            return this.commitAt;
    }

    public A withCommitAt(DateTime commitAt){
            this.commitAt=commitAt; return (A) this;
    }

    public Boolean hasCommitAt(){
            return this.commitAt != null;
    }

    public A withNewCommitAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withCommitAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewCommitAt(Object arg0){
            return (A)withCommitAt(new DateTime(arg0));
    }

    public A withNewCommitAt(long arg0){
            return (A)withCommitAt(new DateTime(arg0));
    }

    public String getCommitID(){
            return this.commitID;
    }

    public A withCommitID(String commitID){
            this.commitID=commitID; return (A) this;
    }

    public Boolean hasCommitID(){
            return this.commitID != null;
    }

    public A withNewCommitID(String arg1){
            return (A)withCommitID(new String(arg1));
    }

    public A withNewCommitID(StringBuilder arg1){
            return (A)withCommitID(new String(arg1));
    }

    public A withNewCommitID(StringBuffer arg1){
            return (A)withCommitID(new String(arg1));
    }

    public String getCommitMessage(){
            return this.commitMessage;
    }

    public A withCommitMessage(String commitMessage){
            this.commitMessage=commitMessage; return (A) this;
    }

    public Boolean hasCommitMessage(){
            return this.commitMessage != null;
    }

    public A withNewCommitMessage(String arg1){
            return (A)withCommitMessage(new String(arg1));
    }

    public A withNewCommitMessage(StringBuilder arg1){
            return (A)withCommitMessage(new String(arg1));
    }

    public A withNewCommitMessage(StringBuffer arg1){
            return (A)withCommitMessage(new String(arg1));
    }

    public String getCommitterEmail(){
            return this.committerEmail;
    }

    public A withCommitterEmail(String committerEmail){
            this.committerEmail=committerEmail; return (A) this;
    }

    public Boolean hasCommitterEmail(){
            return this.committerEmail != null;
    }

    public A withNewCommitterEmail(String arg1){
            return (A)withCommitterEmail(new String(arg1));
    }

    public A withNewCommitterEmail(StringBuilder arg1){
            return (A)withCommitterEmail(new String(arg1));
    }

    public A withNewCommitterEmail(StringBuffer arg1){
            return (A)withCommitterEmail(new String(arg1));
    }

    public String getCommitterName(){
            return this.committerName;
    }

    public A withCommitterName(String committerName){
            this.committerName=committerName; return (A) this;
    }

    public Boolean hasCommitterName(){
            return this.committerName != null;
    }

    public A withNewCommitterName(String arg1){
            return (A)withCommitterName(new String(arg1));
    }

    public A withNewCommitterName(StringBuilder arg1){
            return (A)withCommitterName(new String(arg1));
    }

    public A withNewCommitterName(StringBuffer arg1){
            return (A)withCommitterName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RepositoryCommitFluentImpl that = (V1alpha1RepositoryCommitFluentImpl) o;
            if (commitAt != null ? !commitAt.equals(that.commitAt) :that.commitAt != null) return false;
            if (commitID != null ? !commitID.equals(that.commitID) :that.commitID != null) return false;
            if (commitMessage != null ? !commitMessage.equals(that.commitMessage) :that.commitMessage != null) return false;
            if (committerEmail != null ? !committerEmail.equals(that.committerEmail) :that.committerEmail != null) return false;
            if (committerName != null ? !committerName.equals(that.committerName) :that.committerName != null) return false;
            return true;
    }




}
