package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1RoleMetaFluentImpl<A extends V1alpha1RoleMetaFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1RoleMetaFluent<A>{

    private Map<String,String> custom;
    private V1ObjectMeta metadata;
    private String name;

    public V1alpha1RoleMetaFluentImpl(){
    }
    public V1alpha1RoleMetaFluentImpl(V1alpha1RoleMeta instance){
            this.withCustom(instance.getCustom());

            this.withMetadata(instance.getMetadata());

            this.withName(instance.getName());

    }

    public A addToCustom(String key,String value){
            if(this.custom == null && key != null && value != null) { this.custom = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.custom.put(key, value);} return (A)this;
    }

    public A addToCustom(Map<String,String> map){
            if(this.custom == null && map != null) { this.custom = new LinkedHashMap<String,String>(); }
            if(map != null) { this.custom.putAll(map);} return (A)this;
    }

    public A removeFromCustom(String key){
            if(this.custom == null) { return (A) this; }
            if(key != null && this.custom != null) {this.custom.remove(key);} return (A)this;
    }

    public A removeFromCustom(Map<String,String> map){
            if(this.custom == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.custom != null){this.custom.remove(key);}}} return (A)this;
    }

    public Map<String,String> getCustom(){
            return this.custom;
    }

    public A withCustom(Map<String,String> custom){
            if (custom == null) { this.custom =  null;} else {this.custom = new LinkedHashMap<String,String>(custom);} return (A) this;
    }

    public Boolean hasCustom(){
            return this.custom != null;
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RoleMetaFluentImpl that = (V1alpha1RoleMetaFluentImpl) o;
            if (custom != null ? !custom.equals(that.custom) :that.custom != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
