package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1UserRoleOperationBuilder extends V1alpha1UserRoleOperationFluentImpl<V1alpha1UserRoleOperationBuilder> implements VisitableBuilder<V1alpha1UserRoleOperation,V1alpha1UserRoleOperationBuilder>{

    V1alpha1UserRoleOperationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1UserRoleOperationBuilder(){
            this(true);
    }
    public V1alpha1UserRoleOperationBuilder(Boolean validationEnabled){
            this(new V1alpha1UserRoleOperation(), validationEnabled);
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperationFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1UserRoleOperation(), validationEnabled);
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperationFluent<?> fluent,V1alpha1UserRoleOperation instance){
            this(fluent, instance, true);
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperationFluent<?> fluent,V1alpha1UserRoleOperation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOperation(instance.getOperation());

            fluent.withRole(instance.getRole());

            fluent.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperation instance){
            this(instance,true);
    }
    public V1alpha1UserRoleOperationBuilder(V1alpha1UserRoleOperation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOperation(instance.getOperation());

            this.withRole(instance.getRole());

            this.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1UserRoleOperation build(){
            V1alpha1UserRoleOperation buildable = new V1alpha1UserRoleOperation();
            buildable.setOperation(fluent.getOperation());
            buildable.setRole(fluent.getRole());
            buildable.setUser(fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1UserRoleOperationBuilder that = (V1alpha1UserRoleOperationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
